/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.openstack.swift.CopyObjectException;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.internal.BaseSwiftExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="SwiftClientExpectTest")
public class SwiftClientExpectTest
extends BaseSwiftExpectTest<SwiftClient> {
    @Test
    public void testContainerExistsWhenResponseIs2xxReturnsTrue() {
        HttpRequest headContainer = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse headContainerResponse = HttpResponse.builder().statusCode(200).build();
        SwiftClient clientWhenContainerExists = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, headContainer, headContainerResponse);
        Assert.assertTrue((boolean)clientWhenContainerExists.containerExists("foo"));
    }

    @Test
    public void testContainerExistsWhenResponseIs404ReturnsFalse() {
        HttpRequest headContainer = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse headContainerResponse = HttpResponse.builder().statusCode(404).build();
        SwiftClient clientWhenContainerDoesntExist = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, headContainer, headContainerResponse);
        Assert.assertFalse((boolean)clientWhenContainerDoesntExist.containerExists("foo"));
    }

    @Test
    public void testSetContainerMetadataWhenResponseIs2xxReturnsTrue() {
        HttpRequest setContainerMetadataRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("X-Container-Meta-key", new String[]{"value"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse setContainerMetadataResponse = HttpResponse.builder().statusCode(204).build();
        SwiftClient clientSetContainerMetadata = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, setContainerMetadataRequest, setContainerMetadataResponse);
        Assert.assertTrue((boolean)clientSetContainerMetadata.setContainerMetadata("foo", (Map)ImmutableMap.of((Object)"key", (Object)"value")));
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testSetContainerMetadataWhenResponseIs400ThrowsException() {
        HttpRequest setContainerMetadataRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("X-Container-Meta-", new String[]{"value"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse setContainerMetadataResponse = HttpResponse.builder().statusCode(400).message("Metadata name cannot be empty").build();
        SwiftClient clientSetContainerMetadata = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, setContainerMetadataRequest, setContainerMetadataResponse);
        clientSetContainerMetadata.setContainerMetadata("foo", (Map)ImmutableMap.of((Object)"", (Object)"value"));
    }

    @Test
    public void testSetContainerMetadataWhenResponseIs404ReturnsFalse() {
        HttpRequest setContainerMetadataRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("X-Container-Meta-key", new String[]{"value"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse setContainerMetadataResponse = HttpResponse.builder().statusCode(404).build();
        SwiftClient clientSetContainerMetadata = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, setContainerMetadataRequest, setContainerMetadataResponse);
        Assert.assertFalse((boolean)clientSetContainerMetadata.setContainerMetadata("foo", (Map)ImmutableMap.of((Object)"key", (Object)"value")));
    }

    @Test
    public void testDeleteContainerMetadataWhenResponseIs2xxReturnsTrue() {
        HttpRequest deleteContainerMetadataRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("X-Remove-Container-Meta-bar", new String[]{""})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteContainerMetadataResponse = HttpResponse.builder().statusCode(204).build();
        SwiftClient clientDeleteContainerMetadata = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, deleteContainerMetadataRequest, deleteContainerMetadataResponse);
        Assert.assertTrue((boolean)clientDeleteContainerMetadata.deleteContainerMetadata("foo", (Iterable)ImmutableList.of((Object)"bar")));
    }

    @Test
    public void testDeleteContainerMetadataEmptyWhenResponseIs2xxReturnsTrue() {
        HttpRequest deleteContainerMetadataRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("X-Remove-Container-Meta-", new String[]{""})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteContainerMetadataResponse = HttpResponse.builder().statusCode(204).build();
        SwiftClient clientDeleteContainerMetadata = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, deleteContainerMetadataRequest, deleteContainerMetadataResponse);
        Assert.assertTrue((boolean)clientDeleteContainerMetadata.deleteContainerMetadata("foo", (Iterable)ImmutableList.of((Object)"")));
    }

    @Test
    public void testDeleteContainerMetadataWhenResponseIs404ReturnsFalse() {
        HttpRequest deleteContainerMetadataRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint(this.swiftEndpointWithHostReplaced + "/foo").addHeader("X-Remove-Container-Meta-bar", new String[]{""})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteContainerMetadataResponse = HttpResponse.builder().statusCode(404).build();
        SwiftClient clientDeleteContainerMetadata = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, deleteContainerMetadataRequest, deleteContainerMetadataResponse);
        Assert.assertFalse((boolean)clientDeleteContainerMetadata.deleteContainerMetadata("foo", (Iterable)ImmutableList.of((Object)"bar")));
    }

    @Test
    public void testCopyObjectWhenResponseIs2xxReturnsTrue() {
        String sourceContainer = "bar";
        String sourceObject = "foo.txt";
        String sourcePath = "/" + sourceContainer + "/" + sourceObject;
        String destinationContainer = "foo";
        String destinationObject = "bar.txt";
        String destinationPath = "/" + destinationContainer + "/" + destinationObject;
        HttpRequest copyObjectRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint(this.swiftEndpointWithHostReplaced + destinationPath).addHeader("X-Copy-From", new String[]{sourcePath})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse copyObjectResponse = HttpResponse.builder().statusCode(201).build();
        SwiftClient clientCopyObject = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, copyObjectRequest, copyObjectResponse);
        Assert.assertTrue((boolean)clientCopyObject.copyObject(sourceContainer, sourceObject, destinationContainer, destinationObject));
    }

    @Test(expectedExceptions={CopyObjectException.class})
    public void testCopyObjectWhenResponseIs404ThrowsException() {
        String sourceContainer = "bar";
        String sourceObject = "foo.txt";
        String sourcePath = "/" + sourceContainer + "/" + sourceObject;
        String destinationContainer = "foo";
        String destinationObject = "bar.txt";
        String destinationPath = "/" + destinationContainer + "/" + destinationObject;
        HttpRequest copyObjectRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint(this.swiftEndpointWithHostReplaced + destinationPath).addHeader("X-Copy-From", new String[]{sourcePath})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse copyObjectResponse = HttpResponse.builder().statusCode(404).build();
        SwiftClient clientCopyObject = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, copyObjectRequest, copyObjectResponse);
        Assert.assertTrue((boolean)clientCopyObject.copyObject(sourceContainer, sourceObject, destinationContainer, destinationObject));
    }
}

