/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseContainerMetadataFromHeaders
implements Function<HttpResponse, ContainerMetadata>,
InvocationContext<ParseContainerMetadataFromHeaders> {
    private GeneratedHttpRequest request;

    public ContainerMetadata apply(HttpResponse from) {
        return ((ContainerMetadata.Builder)((ContainerMetadata.Builder)((ContainerMetadata.Builder)((ContainerMetadata.Builder)((ContainerMetadata.Builder)ContainerMetadata.builder().name(this.request.getArgs().get(0).toString())).readACL(from.getFirstHeaderOrNull("X-Container-Read"))).bytes(Long.valueOf(from.getFirstHeaderOrNull("X-Container-Bytes-Used")))).count(Long.valueOf(from.getFirstHeaderOrNull("X-Container-Object-Count")))).metadata(this.extractUserMetadata(from))).build();
    }

    @VisibleForTesting
    Map<String, String> extractUserMetadata(HttpResponse from) {
        HashMap metadata = Maps.newHashMap();
        for (Map.Entry header : from.getHeaders().entries()) {
            if (header.getKey() == null || !((String)header.getKey()).startsWith("X-Container-Meta-")) continue;
            metadata.put(((String)header.getKey()).substring("X-Container-Meta-".length()).toLowerCase(), header.getValue());
        }
        return metadata;
    }

    public ParseContainerMetadataFromHeaders setContext(HttpRequest request) {
        Preconditions.checkArgument((boolean)(request instanceof GeneratedHttpRequest), (Object)"note this handler requires a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)request;
        return this;
    }
}

