/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.LocalAsyncBlobStore;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.HttpGetOptionsListToGetOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.concurrent.Futures;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.functions.ListContainerOptionsToBlobStoreListContainerOptions;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectInfo;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectList;
import org.jclouds.openstack.swift.domain.AccountMetadata;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.options.CreateContainerOptions;
import org.jclouds.openstack.swift.options.ListContainerOptions;

@Singleton
public class StubSwiftAsyncClient
implements CommonSwiftAsyncClient {
    private final HttpGetOptionsListToGetOptions httpGetOptionsConverter;
    private final LocalAsyncBlobStore blobStore;
    private final SwiftObject.Factory objectProvider;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ResourceToObjectInfo blob2ObjectInfo;
    private final ListContainerOptionsToBlobStoreListContainerOptions container2ContainerListOptions;
    private final ResourceToObjectList resource2ObjectList;
    private final ExecutorService service;

    @Inject
    private StubSwiftAsyncClient(@Named(value="jclouds.user-threads") ExecutorService service, LocalAsyncBlobStore blobStore, SwiftObject.Factory objectProvider, HttpGetOptionsListToGetOptions httpGetOptionsConverter, ObjectToBlob object2Blob, BlobToObject blob2Object, ResourceToObjectInfo blob2ObjectInfo, ListContainerOptionsToBlobStoreListContainerOptions container2ContainerListOptions, ResourceToObjectList resource2ContainerList) {
        this.service = service;
        this.blobStore = blobStore;
        this.objectProvider = objectProvider;
        this.httpGetOptionsConverter = httpGetOptionsConverter;
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.blob2ObjectInfo = (ResourceToObjectInfo)Preconditions.checkNotNull((Object)blob2ObjectInfo, (Object)"blob2ObjectInfo");
        this.container2ContainerListOptions = (ListContainerOptionsToBlobStoreListContainerOptions)Preconditions.checkNotNull((Object)container2ContainerListOptions, (Object)"container2ContainerListOptions");
        this.resource2ObjectList = (ResourceToObjectList)Preconditions.checkNotNull((Object)resource2ContainerList, (Object)"resource2ContainerList");
    }

    public ListenableFuture<Boolean> containerExists(String container) {
        return this.blobStore.containerExists(container);
    }

    public ListenableFuture<Boolean> createContainer(String container) {
        return this.blobStore.createContainerInLocation(null, container);
    }

    public ListenableFuture<Boolean> deleteContainerIfEmpty(String container) {
        return this.blobStore.deleteContainerIfEmpty(container);
    }

    public ListenableFuture<Boolean> disableCDN(String container) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<URI> enableCDN(String container, long ttl) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<URI> enableCDN(String container) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<AccountMetadata> getAccountStatistics() {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<SwiftObject> getObject(String container, String key, org.jclouds.http.options.GetOptions ... options) {
        GetOptions getOptions = this.httpGetOptionsConverter.apply(options);
        return Futures.compose((Future)this.blobStore.getBlob(container, key, getOptions), (Function)this.blob2Object, (ExecutorService)this.service);
    }

    public ListenableFuture<MutableObjectInfoWithMetadata> getObjectInfo(String container, String key) {
        return Futures.compose((Future)this.blobStore.blobMetadata(container, key), (Function)new Function<BlobMetadata, MutableObjectInfoWithMetadata>(){

            public MutableObjectInfoWithMetadata apply(BlobMetadata from) {
                return StubSwiftAsyncClient.this.blob2ObjectInfo.apply((StorageMetadata)from);
            }
        }, (ExecutorService)this.service);
    }

    public ListenableFuture<? extends Set<ContainerMetadata>> listContainers(ListContainerOptions ... options) {
        PageSet listing;
        try {
            listing = (PageSet)this.blobStore.list().get();
        }
        catch (ExecutionException ee) {
            throw Throwables.propagate((Throwable)ee);
        }
        catch (InterruptedException ie) {
            throw Throwables.propagate((Throwable)ie);
        }
        return com.google.common.util.concurrent.Futures.immediateFuture((Object)Sets.newHashSet((Iterable)Iterables.transform((Iterable)listing, (Function)new Function<StorageMetadata, ContainerMetadata>(){

            public ContainerMetadata apply(StorageMetadata md) {
                return ContainerMetadata.builder().name(md.getName()).count(-1L).bytes(-1L).metadata(new HashMap()).build();
            }
        })));
    }

    public ListenableFuture<ContainerMetadata> getContainerMetadata(String container) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<Boolean> setContainerMetadata(String container, Map<String, String> containerMetadata) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<Boolean> deleteContainerMetadata(String container, Iterable<String> metadataKeys) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<Boolean> createContainer(String container, CreateContainerOptions ... options) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<PageSet<ObjectInfo>> listObjects(String container, ListContainerOptions ... optionsList) {
        org.jclouds.blobstore.options.ListContainerOptions options = this.container2ContainerListOptions.apply(optionsList);
        return Futures.compose((Future)this.blobStore.list(container, options), (Function)this.resource2ObjectList, (ExecutorService)this.service);
    }

    public ListenableFuture<Boolean> copyObject(String sourceContainer, String sourceObject, String destinationContainer, String destinationObject) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<String> putObject(String container, SwiftObject object) {
        return this.blobStore.putBlob(container, this.object2Blob.apply(object));
    }

    public ListenableFuture<Void> removeObject(String container, String key) {
        return this.blobStore.removeBlob(container, key);
    }

    public ListenableFuture<String> putObjectManifest(String container, String name) {
        return null;
    }

    public ListenableFuture<Boolean> setObjectInfo(String container, String key, Map<String, String> userMetadata) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<URI> updateCDN(String container, long ttl) {
        throw new UnsupportedOperationException();
    }

    public SwiftObject newSwiftObject() {
        return this.objectProvider.create(null);
    }

    public ListenableFuture<Boolean> objectExists(String bucketName, String key) {
        return this.blobStore.blobExists(bucketName, key);
    }
}

