/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.handlers;

import com.google.common.base.Strings;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.CopyObjectException;
import org.jclouds.openstack.swift.handlers.ParseSwiftErrorFromHttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseSwiftErrorFromHttpResponseTest {
    @Test
    public void test404SetsCopyObjectException() {
        this.assertCodeMakes("HEAD", URI.create("http://host/v1/MossoCloudFS_7064cdb1d49d4dcba3c899ac33e8409d/adriancole-blobstore1/key"), 404, "Not Found", "text/plain", "", "/bad/source/path", CopyObjectException.class);
    }

    @Test
    public void test404SetsKeyNotFoundExceptionMosso() {
        this.assertCodeMakes("HEAD", URI.create("http://host/v1/MossoCloudFS_7064cdb1d49d4dcba3c899ac33e8409d/adriancole-blobstore1/key"), 404, "Not Found", "", KeyNotFoundException.class);
    }

    @Test
    public void test404SetsKeyNotFoundExceptionSwift() {
        this.assertCodeMakes("HEAD", URI.create("http://67.202.39.175:8080/v1/AUTH_7064cdb1d49d4dcba3c899ac33e8409d/adriancole-blobstore1/key"), 404, "Not Found", "", KeyNotFoundException.class);
    }

    @Test
    public void test404SetsContainerNotFoundExceptionMosso() {
        this.assertCodeMakes("HEAD", URI.create("http://host/v1/MossoCloudFS_7064cdb1d49d4dcba3c899ac33e8409d/adriancole-blobstore1"), 404, "Not Found", "", ContainerNotFoundException.class);
    }

    @Test
    public void test404SetsContainerNotFoundExceptionSwift() {
        this.assertCodeMakes("HEAD", URI.create("http://67.202.39.175:8080/v1/AUTH_7064cdb1d49d4dcba3c899ac33e8409d/adriancole-blobstore1"), 404, "Not Found", "", ContainerNotFoundException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/plain", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, contentType, content, "", expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, String copyObjectSourcePath, Class<? extends Exception> expected) {
        ParseSwiftErrorFromHttpResponse function = new ParseSwiftErrorFromHttpResponse();
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest.Builder requestBuilder = HttpRequest.builder().method(method).endpoint(uri);
        if (!Strings.isNullOrEmpty((String)copyObjectSourcePath)) {
            requestBuilder.addHeader("X-Copy-From", new String[]{copyObjectSourcePath});
        }
        HttpRequest request = requestBuilder.build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(ParseSwiftErrorFromHttpResponseTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

