/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import org.easymock.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.functions.ParseObjectInfoFromHeaders;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseObjectInfoFromHeadersTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.blobstore.metaprefix")).to("sdf");
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.api-version")).to("1");
        }
    }});

    public void testEtagCaseIssue() {
        ParseObjectInfoFromHeaders parser = (ParseObjectInfoFromHeaders)this.i.getInstance(ParseObjectInfoFromHeaders.class);
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)"container", (Object)"key")).atLeastOnce();
        EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/test")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{request});
        parser.setContext((HttpRequest)request);
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("Last-Modified", new String[]{"Fri, 12 Jun 2007 13:40:18 GMT"})).addHeader("Content-Length", new String[]{"0"})).addHeader("Etag", new String[]{"feb1"})).build();
        response.getPayload().getContentMetadata().setContentType("text/plain");
        MutableObjectInfoWithMetadata md = parser.apply(response);
        Assert.assertNotNull((Object)md.getHash());
    }
}

