/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.functions.ParseContainerMetadataFromHeaders;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseContainerMetadataFromHeadersTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
        }
    }});

    public void testParseContainerMetadataHeaders() {
        ParseContainerMetadataFromHeaders parser = (ParseContainerMetadataFromHeaders)this.i.getInstance(ParseContainerMetadataFromHeaders.class);
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)"container", (Object)"key")).atLeastOnce();
        EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/test")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{request});
        parser.setContext((HttpRequest)request);
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(204).message("No Content").payload("")).addHeader("X-Container-Bytes-Used", new String[]{"42"})).addHeader("X-Container-Object-Count", new String[]{"1"})).addHeader("X-Container-Meta-label1", new String[]{"test1"})).addHeader("X-Container-Meta-label2", new String[]{"test2"})).build();
        response.getPayload().getContentMetadata().setContentType("text/plain");
        ContainerMetadata containerMetadata = parser.apply(response);
        Assert.assertEquals((long)containerMetadata.getBytes(), (long)42L);
        Assert.assertEquals((long)containerMetadata.getCount(), (long)1L);
        Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("label1")), (String)"test1");
        Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("label2")), (String)"test2");
    }
}

