/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.easymock.EasyMock;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.swift.domain.internal.ObjectInfoImpl;
import org.jclouds.openstack.swift.functions.ParseObjectInfoListFromJsonResponse;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseObjectInfoListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        }
    }, new GsonModule()});

    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_container.json");
        ImmutableSet expects = ImmutableSet.of((Object)ObjectInfoImpl.builder().container("container").name("test_obj_1").uri(URI.create("http://localhost/foo/test_obj_1")).hash(CryptoStreams.hex((String)"4281c348eaf83e70ddce0e07221c3d28")).bytes(Long.valueOf(14L)).contentType("application/octet-stream").lastModified(new SimpleDateFormatDateService().iso8601DateParse("2009-02-03T05:26:32.612Z")).build(), (Object)ObjectInfoImpl.builder().container("container").name("test_obj_2").uri(URI.create("http://localhost/foo/test_obj_2")).hash(CryptoStreams.hex((String)"b039efe731ad111bc1b0ef221c3849d0")).bytes(Long.valueOf(64L)).contentType("application/octet-stream").lastModified(new SimpleDateFormatDateService().iso8601DateParse("2009-02-03T05:26:32.612Z")).build());
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        ListContainerOptions options = new ListContainerOptions();
        EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/foo")).atLeastOnce();
        EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)"container", (Object)new ListContainerOptions[]{options})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{request});
        ParseObjectInfoListFromJsonResponse parser = (ParseObjectInfoListFromJsonResponse)this.i.getInstance(ParseObjectInfoListFromJsonResponse.class);
        parser.setContext((HttpRequest)request);
        Assert.assertEquals((String)parser.apply(is).toString(), (String)expects.toString());
    }
}

