/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.openstack.swift.options.ListContainerOptions;

@Singleton
public class BlobStoreListContainerOptionsToListContainerOptions
implements Function<org.jclouds.blobstore.options.ListContainerOptions, ListContainerOptions> {
    public ListContainerOptions apply(org.jclouds.blobstore.options.ListContainerOptions from) {
        Preconditions.checkNotNull((Object)from, (Object)"set options to instance NONE instead of passing null");
        ListContainerOptions options = new ListContainerOptions();
        if (from.getDir() == null && from.isRecursive()) {
            options.withPrefix("");
        }
        if (from.getDir() == null && !from.isRecursive()) {
            options.underPath("");
        }
        if (from.getDir() != null && from.isRecursive()) {
            options.withPrefix(from.getDir().endsWith("/") ? from.getDir() : from.getDir() + "/");
        }
        if (from.getDir() != null && !from.isRecursive()) {
            options.underPath(from.getDir());
        }
        if (from.getMarker() != null) {
            options.afterMarker(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            options.maxResults(from.getMaxResults());
        }
        return options;
    }
}

