/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class SwiftApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<SwiftClient, SwiftAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<SwiftClient, SwiftAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata((ApiMetadata)this);
    }

    public SwiftApiMetadata() {
        this(new Builder(SwiftClient.class, SwiftAsyncClient.class));
    }

    protected SwiftApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.blobstore.metaprefix", "X-Object-Meta-");
        properties.setProperty("jclouds.regions", "DEFAULT");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> syncClient, Class<?> asyncClient) {
            super(syncClient, asyncClient);
            this.id("swift").name("OpenStack Swift with SwiftAuth").identityName("tenantId:user").credentialName("password").documentation(URI.create("http://api.openstack.org/")).version("1.0").defaultProperties(SwiftApiMetadata.defaultProperties()).view(TypeToken.of(BlobStoreContext.class)).context(CONTEXT_TOKEN).defaultModules((Set)ImmutableSet.of(SwiftRestClientModule.StorageEndpointModule.class, SwiftRestClientModule.class, SwiftBlobStoreContextModule.class));
        }

        public SwiftApiMetadata build() {
            return new SwiftApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

