/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.functions.ReturnFalseOnContainerNotFound;
import org.jclouds.blobstore.functions.ReturnFalseOnKeyNotFound;
import org.jclouds.blobstore.functions.ReturnNullOnKeyNotFound;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.binders.BindSwiftObjectMetadataToRequest;
import org.jclouds.openstack.swift.domain.AccountMetadata;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.functions.ObjectName;
import org.jclouds.openstack.swift.functions.ParseAccountMetadataResponseFromHeaders;
import org.jclouds.openstack.swift.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.openstack.swift.functions.ParseObjectInfoFromHeaders;
import org.jclouds.openstack.swift.functions.ParseObjectInfoListFromJsonResponse;
import org.jclouds.openstack.swift.functions.ReturnTrueOn404FalseOn409;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@SkipEncoding(value={47})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Storage.class)
public interface CommonSwiftAsyncClient {
    @Provides
    public SwiftObject newSwiftObject();

    @HEAD
    @ResponseParser(value=ParseAccountMetadataResponseFromHeaders.class)
    @Path(value="/")
    public ListenableFuture<AccountMetadata> getAccountStatistics();

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/")
    public ListenableFuture<? extends Set<ContainerMetadata>> listContainers(ListContainerOptions ... var1);

    @POST
    @Path(value="/{container}/{name}")
    public ListenableFuture<Boolean> setObjectInfo(@PathParam(value="container") String var1, @PathParam(value="name") String var2, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var3);

    @PUT
    @Path(value="/{container}")
    public ListenableFuture<Boolean> createContainer(@PathParam(value="container") String var1);

    @DELETE
    @ExceptionParser(value=ReturnTrueOn404FalseOn409.class)
    @Path(value="/{container}")
    public ListenableFuture<Boolean> deleteContainerIfEmpty(@PathParam(value="container") String var1);

    @GET
    @QueryParams(keys={"format"}, values={"json"})
    @ResponseParser(value=ParseObjectInfoListFromJsonResponse.class)
    @Path(value="/{container}")
    public ListenableFuture<PageSet<ObjectInfo>> listObjects(@PathParam(value="container") String var1, ListContainerOptions ... var2);

    @HEAD
    @Path(value="/{container}")
    @ExceptionParser(value=ReturnFalseOnContainerNotFound.class)
    public ListenableFuture<Boolean> containerExists(@PathParam(value="container") String var1);

    @PUT
    @Path(value="/{container}/{name}")
    @ResponseParser(value=ParseETagHeader.class)
    public ListenableFuture<String> putObject(@PathParam(value="container") String var1, @PathParam(value="name") @ParamParser(value=ObjectName.class) @BinderParam(value=BindSwiftObjectMetadataToRequest.class) SwiftObject var2);

    @GET
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    @ExceptionParser(value=ReturnNullOnKeyNotFound.class)
    @Path(value="/{container}/{name}")
    public ListenableFuture<SwiftObject> getObject(@PathParam(value="container") String var1, @PathParam(value="name") String var2, GetOptions ... var3);

    @HEAD
    @ResponseParser(value=ParseObjectInfoFromHeaders.class)
    @ExceptionParser(value=ReturnNullOnKeyNotFound.class)
    @Path(value="/{container}/{name}")
    public ListenableFuture<MutableObjectInfoWithMetadata> getObjectInfo(@PathParam(value="container") String var1, @PathParam(value="name") String var2);

    @HEAD
    @ExceptionParser(value=ReturnFalseOnKeyNotFound.class)
    @Path(value="/{container}/{name}")
    public ListenableFuture<Boolean> objectExists(@PathParam(value="container") String var1, @PathParam(value="name") String var2);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Path(value="/{container}/{name}")
    public ListenableFuture<Void> removeObject(@PathParam(value="container") String var1, @PathParam(value="name") String var2);

    @PUT
    @Path(value="/{container}/{name}")
    @ResponseParser(value=ParseETagHeader.class)
    @Headers(keys={"X-Object-Manifest"}, values={"{container}/{name}"})
    public ListenableFuture<String> putObjectManifest(@PathParam(value="container") String var1, @PathParam(value="name") String var2);
}

