/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;

public class ParseSwiftErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final String PREFIX = "^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/";
    public static final Pattern CONTAINER_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)$");
    public static final Pattern CONTAINER_KEY_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)/(.*)");

    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String message = data != null ? new String(data) : null;
        HttpResponseException exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 401: {
                exception = new AuthorizationException(exception.getMessage(), (Throwable)exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                String path = command.getCurrentRequest().getEndpoint().getPath();
                Matcher matcher = CONTAINER_PATH.matcher(path);
                HttpResponseException oldException = exception;
                if (matcher.find()) {
                    exception = new ContainerNotFoundException(matcher.group(1), message);
                    exception.initCause((Throwable)oldException);
                    break;
                }
                matcher = CONTAINER_KEY_PATH.matcher(path);
                if (!matcher.find()) break;
                exception = new KeyNotFoundException(matcher.group(1), matcher.group(2), message);
                exception.initCause((Throwable)oldException);
            }
        }
        command.setException((Exception)exception);
    }
}

