/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectInfo;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class ResourceToObjectList
implements Function<PageSet<? extends StorageMetadata>, PageSet<ObjectInfo>> {
    private final ResourceToObjectInfo resource2ObjectMd;

    @Inject
    public ResourceToObjectList(ResourceToObjectInfo resource2ObjectMd) {
        this.resource2ObjectMd = resource2ObjectMd;
    }

    public PageSet<ObjectInfo> apply(PageSet<? extends StorageMetadata> list) {
        return new PageSetImpl(Iterables.transform(list, (Function)new Function<StorageMetadata, ObjectInfo>(){

            public ObjectInfo apply(StorageMetadata from) {
                return ResourceToObjectList.this.resource2ObjectMd.apply(from);
            }
        }), list.getNextMarker());
    }
}

