/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.openstack.swift.CommonSwiftClientTest;
import org.jclouds.openstack.swift.binders.BindSwiftObjectMetadataToRequest;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindSwiftObjectMetadataToRequestTest")
public class BindSwiftObjectMetadataToRequestTest
extends CommonSwiftClientTest {
    @Test
    public void testPassWithMinimumDetailsAndPayload5GB() {
        SwiftObject object = ((SwiftObject.Factory)this.injector.getInstance(SwiftObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x140000000L));
        object.setPayload((Payload)payload);
        object.getInfo().setName("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build();
        BindSwiftObjectMetadataToRequest binder = (BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)object), (Object)HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build());
    }

    @Test
    public void testExtendedPropertiesBind() {
        SwiftObject object = ((SwiftObject.Factory)this.injector.getInstance(SwiftObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x140000000L));
        object.setPayload((Payload)payload);
        object.getInfo().setName("foo");
        object.getInfo().getMetadata().putAll(ImmutableMap.of((Object)"foo", (Object)"bar"));
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build();
        BindSwiftObjectMetadataToRequest binder = (BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)object), (Object)HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).headers((Multimap)ImmutableMultimap.of((Object)"X-Object-Meta-foo", (Object)"bar")).build());
    }

    public void testNoContentLengthIsChunked() {
        SwiftObject object = ((SwiftObject.Factory)this.injector.getInstance(SwiftObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(null);
        object.setPayload((Payload)payload);
        object.getInfo().setName("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build();
        BindSwiftObjectMetadataToRequest binder = (BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)object), (Object)HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).headers((Multimap)ImmutableMultimap.of((Object)"Transfer-Encoding", (Object)"chunked")).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNoNameIsBad() {
        SwiftObject object = ((SwiftObject.Factory)this.injector.getInstance(SwiftObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(5368709120000L));
        object.setPayload((Payload)payload);
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build();
        BindSwiftObjectMetadataToRequest binder = (BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class);
        binder.bindToRequest(request, (Object)object);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOver5GBIsBad() {
        SwiftObject object = ((SwiftObject.Factory)this.injector.getInstance(SwiftObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x140000001L));
        object.setPayload((Payload)payload);
        object.getInfo().setName("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build();
        BindSwiftObjectMetadataToRequest binder = (BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class);
        binder.bindToRequest(request, (Object)object);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeSwiftObject() {
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        ((BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class)).bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindSwiftObjectMetadataToRequest binder = (BindSwiftObjectMetadataToRequest)this.injector.getInstance(BindSwiftObjectMetadataToRequest.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(URI.create("http://momma")).build();
        binder.bindToRequest(request, null);
    }
}

