/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.internal.BaseSwiftExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="SwiftClientExpectTest")
public class SwiftClientExpectTest
extends BaseSwiftExpectTest<SwiftClient> {
    public void testContainerExistsWhenResponseIs2xxReturnsTrue() throws Exception {
        HttpRequest headContainer = HttpRequest.builder().method("HEAD").endpoint(URI.create(this.swiftEndpointWithHostReplaced + "/foo")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-Token", (Object)this.authToken).build()).build();
        HttpResponse headContainerResponse = HttpResponse.builder().statusCode(200).build();
        SwiftClient clientWhenContainerExists = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, headContainer, headContainerResponse);
        Assert.assertTrue((boolean)clientWhenContainerExists.containerExists("foo"));
    }

    public void testContainerExistsWhenResponseIs404ReturnsFalse() throws Exception {
        HttpRequest headContainer = HttpRequest.builder().method("HEAD").endpoint(URI.create(this.swiftEndpointWithHostReplaced + "/foo")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-Token", (Object)this.authToken).build()).build();
        HttpResponse headContainerResponse = HttpResponse.builder().statusCode(404).build();
        SwiftClient clientWhenContainerDoesntExist = (SwiftClient)this.requestsSendResponses(this.authRequest, this.authResponse, headContainer, headContainerResponse);
        Assert.assertFalse((boolean)clientWhenContainerDoesntExist.containerExists("foo"));
    }
}

