/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.functions.URIFromAuthenticationResponseForService;
import org.jclouds.openstack.internal.TestOpenStackAuthenticationModule;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SwiftClientTest")
public abstract class CommonSwiftClientTest
extends BaseAsyncClientTest<SwiftAsyncClient> {
    protected String provider = "swift";

    protected TypeLiteral<RestAnnotationProcessor<SwiftAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<SwiftAsyncClient>>(){};
    }

    protected void checkFilters(HttpRequest request) {
    }

    protected ApiMetadata createApiMetadata() {
        return new SwiftApiMetadata().toBuilder().defaultModules((Set)ImmutableSet.of(StorageEndpointModule.class, SwiftRestClientModule.class, SwiftBlobStoreContextModule.class)).build();
    }

    protected Properties setupProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.regions", "US");
        properties.setProperty("jclouds.endpoint", "https://auth");
        properties.setProperty("jclouds.api-version", "1");
        return properties;
    }

    public static class StorageEndpointModule
    extends TestOpenStackAuthenticationModule {
        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(URIFromAuthenticationResponseForService.Factory factory) {
            return factory.create("X-Storage-Url");
        }
    }
}

