/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.domain.AccountMetadata;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public abstract class CommonSwiftClientLiveTest<C extends CommonSwiftClient>
extends BaseBlobStoreIntegrationTest {
    public abstract C getApi();

    @Test(groups={"integration", "live"})
    public void deleteContainerIfEmptyNotFound() throws Exception {
        assert (this.getApi().deleteContainerIfEmpty("dbienf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListOwnedContainers() throws Exception {
        String containerPrefix = this.getContainerName();
        try {
            Set response = this.getApi().listContainers(new ListContainerOptions[0]);
            Assert.assertNotNull((Object)response);
            long initialContainerCount = response.size();
            Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
            String[] containerNames = new String[]{containerPrefix + ".testListOwnedContainers1", containerPrefix + ".testListOwnedContainers2"};
            Assert.assertTrue((boolean)this.getApi().createContainer(containerNames[0]));
            Assert.assertTrue((boolean)this.getApi().createContainer(containerNames[1]));
            response = this.getApi().listContainers(new ListContainerOptions[0]);
            response = this.getApi().listContainers(new ListContainerOptions[]{ListContainerOptions.Builder.afterMarker((String)containerNames[0].substring(0, containerNames[0].length() - 1)).maxResults(1)});
            Assert.assertEquals((int)response.size(), (int)1);
            Assert.assertEquals((String)((ContainerMetadata)Iterables.get((Iterable)response, (int)0)).getName(), (String)containerNames[0]);
            response = this.getApi().listContainers(new ListContainerOptions[]{ListContainerOptions.Builder.afterMarker((String)containerNames[0]).maxResults(1)});
            Assert.assertEquals((int)response.size(), (int)1);
            Assert.assertEquals((String)((ContainerMetadata)Iterables.get((Iterable)response, (int)0)).getName(), (String)containerNames[1]);
            Assert.assertTrue((boolean)this.getApi().deleteContainerIfEmpty(containerNames[0]));
            Assert.assertTrue((boolean)this.getApi().deleteContainerIfEmpty(containerNames[1]));
            Set set = this.getApi().listContainers(new ListContainerOptions[0]);
        }
        finally {
            this.returnContainer(containerPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadAccountMetadata() throws Exception {
        String containerPrefix = this.getContainerName();
        String containerName = containerPrefix + ".testHeadAccountMetadata";
        try {
            AccountMetadata metadata = this.getApi().getAccountStatistics();
            Assert.assertNotNull((Object)metadata);
            long initialContainerCount = metadata.getContainerCount();
            Assert.assertTrue((boolean)this.getApi().createContainer(containerName));
            metadata = this.getApi().getAccountStatistics();
            Assert.assertNotNull((Object)metadata);
            Assert.assertTrue((metadata.getContainerCount() >= initialContainerCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.getApi().deleteContainerIfEmpty(containerName));
        }
        finally {
            this.returnContainer(containerPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutContainers() throws Exception {
        String containerName = this.getContainerName();
        try {
            String containerName1 = containerName + ".hello";
            Assert.assertTrue((boolean)this.getApi().createContainer(containerName1));
            Set response = this.getApi().listContainers(new ListContainerOptions[]{ListContainerOptions.Builder.afterMarker((String)containerName1.substring(0, containerName1.length() - 1)).maxResults(1)});
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.size(), (int)1);
            Assert.assertEquals((String)((ContainerMetadata)Iterables.get((Iterable)response, (int)0)).getName(), (String)(containerName + ".hello"));
            String containerName2 = containerName + "?should-be-illegal-question-char";
            assert (this.getApi().createContainer(containerName2));
            assert (this.getApi().createContainer(containerName + "/illegal-slash-char"));
            Assert.assertTrue((boolean)this.getApi().deleteContainerIfEmpty(containerName1));
            Assert.assertTrue((boolean)this.getApi().deleteContainerIfEmpty(containerName2));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListContainerPath() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerName = this.getContainerName();
        try {
            String data = "foo";
            this.getApi().putObject(containerName, this.newSwiftObject(data, "foo"));
            this.getApi().putObject(containerName, this.newSwiftObject(data, "path/bar"));
            PageSet container = this.getApi().listObjects(containerName, new ListContainerOptions[]{ListContainerOptions.Builder.underPath((String)"")});
            assert (container.getNextMarker() == null);
            Assert.assertEquals((int)container.size(), (int)1);
            Assert.assertEquals((String)((ObjectInfo)Iterables.get((Iterable)container, (int)0)).getName(), (String)"foo");
            container = this.getApi().listObjects(containerName, new ListContainerOptions[]{ListContainerOptions.Builder.underPath((String)"path")});
            assert (container.getNextMarker() == null);
            Assert.assertEquals((int)container.size(), (int)1);
            Assert.assertEquals((String)((ObjectInfo)Iterables.get((Iterable)container, (int)0)).getName(), (String)"path/bar");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObjectOperations() throws Exception {
        String containerName = this.getContainerName();
        try {
            String data = "Here is my data";
            String key = "object";
            SwiftObject object = this.newSwiftObject(data, key);
            byte[] md5 = object.getPayload().getContentMetadata().getContentMD5();
            String newEtag = this.getApi().putObject(containerName, object);
            assert (newEtag != null);
            Assert.assertEquals((String)CryptoStreams.hex((byte[])md5), (String)CryptoStreams.hex((byte[])object.getPayload().getContentMetadata().getContentMD5()));
            assert (this.getApi().getObjectInfo(containerName, "non-existent-object") == null);
            MutableObjectInfoWithMetadata metadata = this.getApi().getObjectInfo(containerName, object.getInfo().getName());
            Assert.assertEquals((String)metadata.getName(), (String)object.getInfo().getName());
            Assert.assertEquals((Object)metadata.getBytes(), (Object)new Long(data.length()));
            assert (metadata.getContentType().startsWith("text/plain")) : metadata.getContentType();
            Assert.assertEquals((String)CryptoStreams.hex((byte[])md5), (String)CryptoStreams.hex((byte[])metadata.getHash()));
            Assert.assertEquals((byte[])metadata.getHash(), (byte[])CryptoStreams.hex((String)newEtag));
            Assert.assertEquals((int)metadata.getMetadata().entrySet().size(), (int)1);
            Assert.assertEquals((String)((String)metadata.getMetadata().get("metadata")), (String)"metadata-value");
            HashMap userMetadata = Maps.newHashMap();
            userMetadata.put("New-Metadata-1", "value-1");
            userMetadata.put("New-Metadata-2", "value-2");
            Assert.assertTrue((boolean)this.getApi().setObjectInfo(containerName, object.getInfo().getName(), (Map)userMetadata));
            assert (this.getApi().getObject(containerName, "non-existent-object", new GetOptions[0]) == null);
            SwiftObject getBlob = this.getApi().getObject(containerName, object.getInfo().getName(), new GetOptions[0]);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)getBlob.getPayload().getInput()), (String)data);
            Assert.assertEquals((Object)getBlob.getInfo().getBytes(), (Object)new Long(data.length()));
            this.testGetObjectContentType(getBlob);
            Assert.assertEquals((String)CryptoStreams.hex((byte[])md5), (String)CryptoStreams.hex((byte[])getBlob.getInfo().getHash()));
            Assert.assertEquals((byte[])CryptoStreams.hex((String)newEtag), (byte[])getBlob.getInfo().getHash());
            Assert.assertEquals((int)getBlob.getInfo().getMetadata().entrySet().size(), (int)2);
            Assert.assertEquals((String)((String)getBlob.getInfo().getMetadata().get("new-metadata-1")), (String)"value-1");
            Assert.assertEquals((String)((String)getBlob.getInfo().getMetadata().get("new-metadata-2")), (String)"value-2");
            String correctEtag = newEtag;
            String incorrectEtag = "0" + correctEtag.substring(1);
            object.getInfo().setHash(CryptoStreams.hex((String)incorrectEtag));
            try {
                this.getApi().putObject(containerName, object);
            }
            catch (HttpResponseException e) {
                Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)422);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getBytes("UTF-8"));
            SwiftObject blob = this.getApi().newSwiftObject();
            blob.getInfo().setName("chunked-object");
            blob.setPayload((InputStream)bais);
            newEtag = this.getApi().putObject(containerName, blob);
            Assert.assertEquals((String)CryptoStreams.hex((byte[])md5), (String)CryptoStreams.hex((byte[])getBlob.getInfo().getHash()));
            try {
                this.getApi().getObject(containerName, object.getInfo().getName(), new GetOptions[]{GetOptions.Builder.ifETagDoesntMatch((String)newEtag)});
            }
            catch (HttpResponseException e) {
                Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)304);
            }
            getBlob = this.getApi().getObject(containerName, object.getInfo().getName(), new GetOptions[]{GetOptions.Builder.ifETagMatches((String)newEtag)});
            Assert.assertEquals((byte[])getBlob.getInfo().getHash(), (byte[])CryptoStreams.hex((String)newEtag));
            getBlob = this.getApi().getObject(containerName, object.getInfo().getName(), new GetOptions[]{GetOptions.Builder.startAt((long)8L)});
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)getBlob.getPayload().getInput()), (String)data.substring(8));
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void testGetObjectContentType(SwiftObject getBlob) {
        String contentType = getBlob.getPayload().getContentMetadata().getContentType();
        assert (contentType.startsWith("text/plain") || "application/x-www-form-urlencoded".equals(contentType)) : contentType;
    }

    private SwiftObject newSwiftObject(String data, String key) throws IOException {
        SwiftObject object = this.getApi().newSwiftObject();
        object.getInfo().setName(key);
        object.setPayload(data);
        Payloads.calculateMD5((PayloadEnclosing)object);
        object.getInfo().setContentType("text/plain");
        object.getInfo().getMetadata().put("Metadata", "metadata-value");
        return object;
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        return props;
    }
}

