/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain;

public class AccountMetadata {
    private long containerCount;
    private long bytes;

    public AccountMetadata(long containerCount, long bytes) {
        this.containerCount = containerCount;
        this.bytes = bytes;
    }

    public AccountMetadata() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceMetadata [bytes=").append(this.bytes).append(", containerCount=").append(this.containerCount).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bytes ^ this.bytes >>> 32);
        result = 31 * result + (int)(this.containerCount ^ this.containerCount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountMetadata other = (AccountMetadata)obj;
        if (this.bytes != other.bytes) {
            return false;
        }
        return this.containerCount == other.containerCount;
    }

    public void setContainerCount(long count) {
        this.containerCount = count;
    }

    public long getContainerCount() {
        return this.containerCount;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public long getBytes() {
        return this.bytes;
    }
}

