/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.config;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.functions.URIFromAuthenticationResponseForService;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.config.SwiftObjectModule;
import org.jclouds.openstack.swift.handlers.ParseSwiftErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.util.Suppliers2;

@ConfiguresRestClient
public class SwiftRestClientModule<S extends CommonSwiftClient, A extends CommonSwiftAsyncClient>
extends RestClientModule<S, A> {
    public SwiftRestClientModule() {
        this((TypeToken<S>)TypeToken.of(SwiftClient.class), (TypeToken<A>)TypeToken.of(SwiftAsyncClient.class), (Map<Class<?>, Class<?>>)ImmutableMap.of());
    }

    protected SwiftRestClientModule(TypeToken<S> syncClientType, TypeToken<A> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        super(syncClientType, asyncClientType, sync2Async);
    }

    protected void configure() {
        this.install((Module)new SwiftObjectModule());
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
        this.bindResolvedClientsToCommonSwift();
    }

    protected void bindResolvedClientsToCommonSwift() {
        this.bind(CommonSwiftClient.class).to(SwiftClient.class).in(Scopes.SINGLETON);
        this.bind(CommonSwiftAsyncClient.class).to(SwiftAsyncClient.class).in(Scopes.SINGLETON);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseSwiftErrorFromHttpResponse.class);
    }

    public static class KeystoneStorageEndpointModule
    extends KeystoneAuthenticationModule.KeystoneAuthenticationModuleForRegions {
        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
            return Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("object-store", apiVersion));
        }
    }

    public static class StorageEndpointModule
    extends OpenStackAuthenticationModule {
        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(URIFromAuthenticationResponseForService.Factory factory) {
            return factory.create("X-Storage-Url");
        }
    }
}

