/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.Binder;

@Singleton
public class BindSwiftObjectMetadataToRequest
implements Binder {
    private final BindUserMetadataToHeadersWithPrefix mdBinder;
    private final ObjectToBlob object2Blob;

    @Inject
    public BindSwiftObjectMetadataToRequest(ObjectToBlob object2Blob, BindUserMetadataToHeadersWithPrefix mdBinder) {
        this.mdBinder = mdBinder;
        this.object2Blob = object2Blob;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof SwiftObject), (Object)"this binder is only valid for SwiftObject!");
        Preconditions.checkNotNull(request, (Object)"request");
        SwiftObject object = (SwiftObject)input;
        if (object.getPayload().getContentMetadata().getContentType() == null) {
            object.getPayload().getContentMetadata().setContentType("application/octet-stream");
        }
        if (object.getPayload().getContentMetadata().getContentLength() != null && object.getPayload().getContentMetadata().getContentLength() >= 0L) {
            Preconditions.checkArgument((object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L ? 1 : 0) != 0, (Object)"maximum size for put object is 5GB");
        } else {
            request = ModifyRequest.replaceHeader(request, (String)"Transfer-Encoding", (String[])new String[]{"chunked"});
        }
        request = this.mdBinder.bindToRequest(request, (Object)this.object2Blob.apply(object));
        return request;
    }
}

