/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.SwiftKeystoneAsyncClient;
import org.jclouds.openstack.swift.SwiftKeystoneClient;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.config.SwiftKeystoneRestClientModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.rest.RestContext;

public class SwiftKeystoneApiMetadata
extends SwiftApiMetadata {
    private static final long serialVersionUID = 820062881469203616L;
    public static final TypeToken<RestContext<SwiftKeystoneClient, SwiftKeystoneAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<SwiftKeystoneClient, SwiftKeystoneAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    private static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return SwiftKeystoneApiMetadata.builder().fromApiMetadata((ApiMetadata)this);
    }

    public SwiftKeystoneApiMetadata() {
        this(SwiftKeystoneApiMetadata.builder());
    }

    protected SwiftKeystoneApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = SwiftApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "object-store");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.remove("jclouds.regions");
        return properties;
    }

    public static class Builder
    extends SwiftApiMetadata.Builder {
        protected Builder() {
            this(SwiftKeystoneClient.class, SwiftKeystoneAsyncClient.class);
        }

        protected Builder(Class<?> syncClient, Class<?> asyncClient) {
            super(syncClient, asyncClient);
            this.id("swift-keystone").name("OpenStack Swift with Keystone authentication").identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant").credentialName("${password}").endpointName("KeyStone base url ending in /v2.0/").defaultEndpoint("http://localhost:5000/v2.0/").context(CONTEXT_TOKEN).defaultProperties(SwiftKeystoneApiMetadata.defaultProperties()).defaultModules((Set)ImmutableSet.of(SwiftRestClientModule.KeystoneStorageEndpointModule.class, KeystoneAuthenticationModule.RegionModule.class, SwiftKeystoneRestClientModule.class, SwiftBlobStoreContextModule.class));
        }

        @Override
        public SwiftKeystoneApiMetadata build() {
            return new SwiftKeystoneApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

