/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.inject.Provides;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.concurrent.Timeout;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.domain.AccountMetadata;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.options.ListContainerOptions;

@Timeout(duration=120L, timeUnit=TimeUnit.SECONDS)
public interface CommonSwiftClient {
    @Provides
    public SwiftObject newSwiftObject();

    public AccountMetadata getAccountStatistics();

    public Set<ContainerMetadata> listContainers(ListContainerOptions ... var1);

    public boolean setObjectInfo(String var1, String var2, Map<String, String> var3);

    public boolean createContainer(String var1);

    public boolean deleteContainerIfEmpty(String var1);

    public PageSet<ObjectInfo> listObjects(String var1, ListContainerOptions ... var2);

    public boolean containerExists(String var1);

    @Timeout(duration=40960L, timeUnit=TimeUnit.SECONDS)
    public String putObject(String var1, SwiftObject var2);

    @Timeout(duration=10240L, timeUnit=TimeUnit.SECONDS)
    public SwiftObject getObject(String var1, String var2, GetOptions ... var3);

    public MutableObjectInfoWithMetadata getObjectInfo(String var1, String var2);

    public void removeObject(String var1, String var2);

    public boolean objectExists(String var1, String var2);

    public String putObjectManifest(String var1, String var2);
}

