/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import java.io.IOException;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.swift.CommonSwiftClientTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SwiftBlobRequestSignerTest")
public class SwiftBlobRequestSignerTest
extends CommonSwiftClientTest {
    private BlobRequestSigner signer;
    private Blob.Factory blobFactory;

    public void testSignGetBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signGetBlob("container", "name");
        this.assertRequestLineEquals(request, "GET http://storage/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "X-Auth-Token: testtoken\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignRemoveBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signRemoveBlob("container", "name");
        this.assertRequestLineEquals(request, "DELETE http://storage/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "X-Auth-Token: testtoken\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignPutBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Blob blob = this.blobFactory.create(null);
        blob.getMetadata().setName("name");
        blob.setPayload("");
        blob.getPayload().getContentMetadata().setContentLength(Long.valueOf(2L));
        blob.getPayload().getContentMetadata().setContentMD5(new byte[]{0, 2, 4, 8});
        blob.getPayload().getContentMetadata().setContentType("text/plain");
        HttpRequest request = this.signer.signPutBlob("container", blob);
        this.assertRequestLineEquals(request, "PUT http://storage/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "X-Auth-Token: testtoken\n");
        this.assertContentHeadersEqual(request, "text/plain", null, null, null, 2L, new byte[]{0, 2, 4, 8});
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobFactory = (Blob.Factory)this.injector.getInstance(Blob.Factory.class);
        this.signer = (BlobRequestSigner)this.injector.getInstance(BlobRequestSigner.class);
    }
}

