/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Properties;
import javax.inject.Singleton;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.TestOpenStackAuthenticationModule;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.config.BaseSwiftRestClientModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SwiftClientTest")
public abstract class CommonSwiftClientTest
extends BaseAsyncClientTest<SwiftAsyncClient> {
    protected String provider = "swift";

    protected TypeLiteral<RestAnnotationProcessor<SwiftAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<SwiftAsyncClient>>(){};
    }

    protected void checkFilters(HttpRequest request) {
    }

    protected Module createModule() {
        return new TestSwiftRestClientModule();
    }

    protected ApiMetadata createApiMetadata() {
        return new SwiftApiMetadata();
    }

    protected Properties setupProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.regions", "US");
        properties.setProperty("jclouds.endpoint", "https://auth");
        properties.setProperty("jclouds.api-version", "1");
        return properties;
    }

    @ConfiguresRestClient
    protected static class TestSwiftRestClientModule
    extends BaseSwiftRestClientModule<SwiftClient, SwiftAsyncClient> {
        private TestSwiftRestClientModule() {
            super((OpenStackAuthenticationModule)new TestOpenStackAuthenticationModule());
        }

        @Provides
        @Singleton
        CommonSwiftClient provideCommonSwiftClient(SwiftClient in) {
            return in;
        }

        @Provides
        @Singleton
        CommonSwiftAsyncClient provideCommonSwiftClient(SwiftAsyncClient in) {
            return in;
        }
    }
}

