/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.functions.ParseAuthenticationResponseFromHeaders;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseAuthenticationResponseFromHeadersTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.blobstore.metaprefix")).to("sdf");
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.api-version")).to("1");
            this.bind(UriBuilder.class).to(UriBuilderImpl.class);
        }
    }});

    public void testReplaceLocalhost() {
        ParseAuthenticationResponseFromHeaders parser = (ParseAuthenticationResponseFromHeaders)this.i.getInstance(ParseAuthenticationResponseFromHeaders.class);
        parser = parser.setHostToReplace("fooman");
        HttpResponse response = new HttpResponse(204, "No Content", null, (Multimap)ImmutableMultimap.of((Object)"X-Auth-Token", (Object)"token", (Object)"X-Storage-Token", (Object)"token", (Object)"X-Storage-Url", (Object)"http://127.0.0.1:8080/v1/token"));
        OpenStackAuthAsyncClient.AuthenticationResponse md = parser.apply(response);
        Assert.assertEquals((Object)md, (Object)new OpenStackAuthAsyncClient.AuthenticationResponse("token", (Map)ImmutableMap.of((Object)"X-Storage-Url", (Object)URI.create("http://fooman:8080/v1/token"))));
    }
}

