/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.config;

import com.google.inject.Provides;
import java.net.URI;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.RequiresHttp;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftClient;
import org.jclouds.openstack.swift.config.BaseSwiftRestClientModule;
import org.jclouds.rest.AsyncClientFactory;
import org.jclouds.rest.ConfiguresRestClient;

@ConfiguresRestClient
@RequiresHttp
public class SwiftRestClientModule
extends BaseSwiftRestClientModule<SwiftClient, SwiftAsyncClient> {
    public SwiftRestClientModule() {
        super(SwiftClient.class, SwiftAsyncClient.class);
    }

    @Provides
    @Singleton
    CommonSwiftClient provideCommonSwiftClient(SwiftClient in) {
        return in;
    }

    @Provides
    @Singleton
    CommonSwiftAsyncClient provideCommonSwiftClient(SwiftAsyncClient in) {
        return in;
    }

    @Override
    protected URI provideStorageUrl(OpenStackAuthAsyncClient.AuthenticationResponse response) {
        return (URI)response.getServices().get("X-Storage-Url");
    }

    @Override
    protected void configure() {
        this.bind(OpenStackAuthenticationModule.GetAuthenticationResponse.class).to(GetAuthenticationResponseForStorage.class);
        super.configure();
    }

    @Singleton
    public static class GetAuthenticationResponseForStorage
    extends OpenStackAuthenticationModule.GetAuthenticationResponse {
        @Inject
        public GetAuthenticationResponseForStorage(AsyncClientFactory factory, @Named(value="jclouds.identity") String user, @Named(value="jclouds.credential") String key) {
            super(factory, user, key);
        }

        protected Future<OpenStackAuthAsyncClient.AuthenticationResponse> authenticate() {
            return this.client.authenticateStorage(this.user, this.key);
        }
    }
}

