/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class SwiftBlobRequestSigner
implements BlobRequestSigner {
    private final RestAnnotationProcessor<CommonSwiftAsyncClient> processor;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Method getMethod;
    private final Method deleteMethod;
    private final Method createMethod;

    @Inject
    public SwiftBlobRequestSigner(RestAnnotationProcessor<CommonSwiftAsyncClient> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions) throws SecurityException, NoSuchMethodException {
        this.processor = (RestAnnotationProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = CommonSwiftAsyncClient.class.getMethod("getObject", String.class, String.class, GetOptions[].class);
        this.deleteMethod = CommonSwiftAsyncClient.class.getMethod("removeObject", String.class, String.class);
        this.createMethod = CommonSwiftAsyncClient.class.getMethod("putObject", String.class, SwiftObject.class);
    }

    public HttpRequest signGetBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{container, name}));
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.createMethod, new Object[]{container, this.blobToObject.apply(blob)}));
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.deleteMethod, new Object[]{container, name}));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.createRequest(this.getMethod, new Object[]{container, name, this.blob2HttpGetOptions.apply(options)}));
    }
}

