/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseContainerListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test
    public void testApplyInputStream() {
        InputStream is = Strings2.toInputStream((String)"[ {\"name\":\"test_container_1\",\"count\":2,\"bytes\":78}, {\"name\":\"test_container_2\",\"count\":1,\"bytes\":17} ]   ");
        ImmutableList expects = ImmutableList.of((Object)new ContainerMetadata("test_container_1", 2L, 78L), (Object)new ContainerMetadata("test_container_2", 1L, 17L));
        ParseJson parser = (ParseJson)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<ParseJson<List<ContainerMetadata>>>(){}));
        Assert.assertEquals((Collection)((Collection)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)))), (Collection)expects);
    }
}

