/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift;

import com.google.inject.Module;
import java.net.URI;
import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.RequiresHttp;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.TestOpenStackAuthenticationModule;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.config.BaseSwiftRestClientModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SwiftClientTest")
public abstract class CommonSwiftClientTest<A extends CommonSwiftAsyncClient>
extends RestClientTest<A> {
    protected String provider = "swift";

    protected void checkFilters(HttpRequest request) {
    }

    protected Module createModule() {
        return new TestSwiftRestClientModule();
    }

    public RestContextSpec<CommonSwiftClient, CommonSwiftAsyncClient> createContextSpec() {
        return new RestContextFactory().createContextSpec(this.provider, "user", "password", new Properties());
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.regions", "US");
        properties.setProperty("jclouds.endpoint", "https://auth");
        properties.setProperty("jclouds.api-version", "1");
        return properties;
    }

    @ConfiguresRestClient
    @RequiresHttp
    protected static class TestSwiftRestClientModule
    extends BaseSwiftRestClientModule<CommonSwiftClient, CommonSwiftAsyncClient> {
        private TestSwiftRestClientModule() {
            super((OpenStackAuthenticationModule)new TestOpenStackAuthenticationModule(), CommonSwiftClient.class, CommonSwiftAsyncClient.class);
        }

        protected URI provideStorageUrl(OpenStackAuthAsyncClient.AuthenticationResponse response) {
            return URI.create("http://storage");
        }
    }
}

