/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectInfo;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.rest.InvocationContext;

public class ParseObjectInfoFromHeaders
implements Function<HttpResponse, MutableObjectInfoWithMetadata>,
InvocationContext<ParseObjectInfoFromHeaders> {
    private final ParseSystemAndUserMetadataFromHeaders blobMetadataParser;
    private final ResourceToObjectInfo blobToObjectInfo;

    @Inject
    public ParseObjectInfoFromHeaders(ParseSystemAndUserMetadataFromHeaders blobMetadataParser, ResourceToObjectInfo blobToObjectInfo) {
        this.blobMetadataParser = blobMetadataParser;
        this.blobToObjectInfo = blobToObjectInfo;
    }

    public MutableObjectInfoWithMetadata apply(HttpResponse from) {
        MutableBlobMetadata base = this.blobMetadataParser.apply(from);
        MutableObjectInfoWithMetadata to = this.blobToObjectInfo.apply((StorageMetadata)base);
        to.setBytes(HttpUtils.attemptToParseSizeAndRangeFromHeaders((HttpMessage)from));
        String eTagHeader = from.getFirstHeaderOrNull("Etag");
        if (eTagHeader != null) {
            to.setHash(CryptoStreams.hex((String)eTagHeader));
        }
        return to;
    }

    public ParseObjectInfoFromHeaders setContext(HttpRequest request) {
        this.blobMetadataParser.setContext(request);
        return this;
    }
}

