/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import java.util.Arrays;
import java.util.Date;
import org.jclouds.openstack.swift.domain.ObjectInfo;

public class ObjectInfoImpl
implements ObjectInfo {
    String name;
    byte[] hash;
    long bytes;
    String content_type;
    Date last_modified;

    ObjectInfoImpl() {
    }

    @Override
    public int compareTo(ObjectInfoImpl o) {
        return this == o ? 0 : this.name.compareTo(o.name);
    }

    @Override
    public Long getBytes() {
        return this.bytes;
    }

    @Override
    public String getContentType() {
        return this.content_type;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public Date getLastModified() {
        return this.last_modified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bytes ^ this.bytes >>> 32);
        result = 31 * result + (this.content_type == null ? 0 : this.content_type.hashCode());
        result = 31 * result + Arrays.hashCode(this.hash);
        result = 31 * result + (this.last_modified == null ? 0 : this.last_modified.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectInfoImpl other = (ObjectInfoImpl)obj;
        if (this.bytes != other.bytes) {
            return false;
        }
        if (this.content_type == null ? other.content_type != null : !this.content_type.equals(other.content_type)) {
            return false;
        }
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        if (this.last_modified == null ? other.last_modified != null : !this.last_modified.equals(other.last_modified)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(ObjectInfo o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "ObjectInfoImpl [bytes=" + this.bytes + ", content_flavor=" + this.content_type + ", hash=" + Arrays.asList(new byte[][]{this.hash}) + ", last_modified=" + this.last_modified.getTime() + ", name=" + this.name + "]";
    }
}

