/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;

public class MutableObjectInfoWithMetadataImpl
implements MutableObjectInfoWithMetadata {
    private String name;
    private Long bytes;
    private byte[] hash;
    private String contentType = "application/octet-stream";
    private Date lastModified;
    private final Map<String, String> metadata = Maps.newHashMap();

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getBytes() {
        return this.bytes;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bytes == null ? 0 : this.bytes.hashCode());
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + Arrays.hashCode(this.hash);
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : ((Object)this.metadata).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableObjectInfoWithMetadataImpl other = (MutableObjectInfoWithMetadataImpl)obj;
        if (this.bytes == null ? other.bytes != null : !this.bytes.equals(other.bytes)) {
            return false;
        }
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !((Object)this.metadata).equals(other.metadata)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(ObjectInfo o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
}

