/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class ObjectToBlobMetadata
implements Function<ObjectInfo, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName;

    @Inject
    public ObjectToBlobMetadata(IfDirectoryReturnNameStrategy ifDirectoryReturnName) {
        this.ifDirectoryReturnName = ifDirectoryReturnName;
    }

    public MutableBlobMetadata apply(ObjectInfo from) {
        String directoryName;
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        to.getContentMetadata().setContentMD5(from.getHash());
        if (from.getContentType() != null) {
            to.getContentMetadata().setContentType(from.getContentType());
        }
        if (from.getHash() != null) {
            to.setETag(CryptoStreams.hex((byte[])from.getHash()));
        }
        to.setName(from.getName());
        if (from.getBytes() != null) {
            to.getContentMetadata().setContentLength(from.getBytes());
        }
        if (from.getLastModified() != null) {
            to.setLastModified(from.getLastModified());
        }
        if (from instanceof MutableObjectInfoWithMetadata) {
            to.setUserMetadata(((MutableObjectInfoWithMetadata)from).getMetadata());
        }
        if ((directoryName = this.ifDirectoryReturnName.execute((StorageMetadata)to)) != null) {
            to.setName(directoryName);
            to.setType((Enum)StorageType.RELATIVE_PATH);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        return to;
    }
}

