/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.servermanager.Datacenter;
import org.jclouds.servermanager.Hardware;
import org.jclouds.servermanager.Image;
import org.jclouds.servermanager.Server;
import org.jclouds.servermanager.ServerManager;

@Singleton
public class ServerManagerComputeServiceAdapter
implements ComputeServiceAdapter<Server, Hardware, Image, Datacenter> {
    private final ServerManager client;

    @Inject
    public ServerManagerComputeServiceAdapter(ServerManager client) {
        this.client = (ServerManager)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        Server from = this.client.createServerInDC(template.getLocation().getId(), name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()));
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)from, from.id + "", LoginCredentials.builder().user(from.loginUser).password(from.password).build());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        return this.client.listHardware();
    }

    public Iterable<Image> listImages() {
        return this.client.listImages();
    }

    public Image getImage(String id) {
        int imageId = Integer.parseInt(id);
        return this.client.getImage(imageId);
    }

    public Iterable<Server> listNodes() {
        return this.client.listServers();
    }

    public Iterable<Server> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Server>(){

            public boolean apply(Server server) {
                return Iterables.contains((Iterable)ids, (Object)Integer.toString(server.id));
            }
        });
    }

    public Iterable<Datacenter> listLocations() {
        return ImmutableSet.of((Object)new Datacenter(1, "SFO"));
    }

    public Server getNode(String id) {
        int serverId = Integer.parseInt(id);
        return this.client.getServer(serverId);
    }

    public void destroyNode(String id) {
        this.client.destroyServer(Integer.parseInt(id));
    }

    public void rebootNode(String id) {
        this.client.rebootServer(Integer.parseInt(id));
    }

    public void resumeNode(String id) {
        this.client.startServer(Integer.parseInt(id));
    }

    public void suspendNode(String id) {
        this.client.stopServer(Integer.parseInt(id));
    }
}

