/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute.functions;

import com.google.common.base.Function;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.servermanager.Image;

@Singleton
public class ServerManagerImageToImage
implements Function<Image, org.jclouds.compute.domain.Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public org.jclouds.compute.domain.Image apply(Image from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.id + "");
        builder.name(from.name);
        builder.description(from.name);
        OsFamily family = null;
        try {
            family = OsFamily.fromValue((String)from.name);
            builder.operatingSystem(new OperatingSystem.Builder().name(from.name).family(family).build());
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("<< didn't match os(%s)", new Object[]{from});
        }
        builder.status(Image.Status.AVAILABLE);
        return builder.build();
    }
}

