/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.servermanager.Datacenter;

@Singleton
public class DatacenterToLocation
implements Function<Datacenter, Location> {
    private final Provider<Supplier<Location>> provider;

    @Inject
    public DatacenterToLocation(Provider<Supplier<Location>> provider) {
        this.provider = (Provider)Preconditions.checkNotNull(provider, (Object)"provider");
    }

    public Location apply(Datacenter from) {
        return new LocationBuilder().scope(LocationScope.ZONE).id(from.id + "").description(from.name).parent((Location)((Supplier)this.provider.get()).get()).build();
    }
}

