/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute;

import com.google.common.collect.ImmutableMap;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true)
public class ServerManagerComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public ServerManagerComputeServiceLiveTest() {
        this.provider = "servermanager";
    }

    @Test
    public void testTemplateBuilder() {
        Template defaultTemplate = this.client.templateBuilder().build();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"5.3");
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.CENTOS);
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)0.5);
    }

    protected JschSshClientModule getSshModule() {
        return new JschSshClientModule();
    }

    protected void checkUserMetadataInNodeEquals(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (((Object)node.getUserMetadata()).equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }
}

