/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute;

import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.StandaloneComputeServiceContextSpec;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.servermanager.ServerManager;
import org.jclouds.servermanager.compute.ServerManagerComputeServiceContextBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ServerManagerComputeServiceContextBuilderTest {
    @Test
    public void testCanBuildDirectly() {
        ComputeServiceContext context = new ServerManagerComputeServiceContextBuilder(new Properties()).buildComputeServiceContext();
        context.close();
    }

    @Test
    public void testCanBuildWithContextSpec() {
        ComputeServiceContext context = new ComputeServiceContextFactory().createContext((RestContextSpec)new StandaloneComputeServiceContextSpec("servermanager", "http://host", "1", "", "", "identity", "credential", ServerManager.class, ServerManagerComputeServiceContextBuilder.class, (Iterable)ImmutableSet.of()));
        context.close();
    }

    @Test
    public void testCanBuildWithRestProperties() {
        Properties restProperties = new Properties();
        restProperties.setProperty("servermanager.contextbuilder", ServerManagerComputeServiceContextBuilder.class.getName());
        restProperties.setProperty("servermanager.endpoint", "http://host");
        restProperties.setProperty("servermanager.api-version", "1");
        ComputeServiceContext context = new ComputeServiceContextFactory(restProperties).createContext("servermanager", "identity", "credential");
        context.close();
    }

    @Test
    public void testProviderSpecificContextIsCorrectType() {
        ComputeServiceContext context = new ServerManagerComputeServiceContextBuilder(new Properties()).buildComputeServiceContext();
        RestContext providerContext = context.getProviderSpecificContext();
        Assert.assertEquals(((ServerManager)providerContext.getApi()).getClass(), ServerManager.class);
        context.close();
    }
}

