/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.servermanager.Server;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    public static final Map<Server.Status, NodeState> serverStatusToNodeState = ImmutableMap.builder().put((Object)Server.Status.ACTIVE, (Object)NodeState.RUNNING).put((Object)Server.Status.BUILD, (Object)NodeState.PENDING).put((Object)Server.Status.TERMINATED, (Object)NodeState.TERMINATED).put((Object)Server.Status.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).build();
    private final FindHardwareForServer findHardwareForServer;
    private final FindLocationForServer findLocationForServer;
    private final FindImageForServer findImageForServer;
    private final Map<String, Credentials> credentialStore;

    @Inject
    ServerToNodeMetadata(Map<String, Credentials> credentialStore, FindHardwareForServer findHardwareForServer, FindLocationForServer findLocationForServer, FindImageForServer findImageForServer) {
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.findHardwareForServer = (FindHardwareForServer)((Object)Preconditions.checkNotNull((Object)((Object)findHardwareForServer), (Object)"findHardwareForServer"));
        this.findLocationForServer = (FindLocationForServer)((Object)Preconditions.checkNotNull((Object)((Object)findLocationForServer), (Object)"findLocationForServer"));
        this.findImageForServer = (FindImageForServer)((Object)Preconditions.checkNotNull((Object)((Object)findImageForServer), (Object)"findImageForServer"));
    }

    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.id + "");
        builder.name(from.name);
        builder.location((Location)this.findLocationForServer.apply(from));
        builder.group(ComputeServiceUtils.parseGroupFromName((String)from.name));
        builder.imageId(from.imageId + "");
        Image image = (Image)this.findImageForServer.apply(from);
        if (image != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        builder.hardware((Hardware)this.findHardwareForServer.apply(from));
        builder.state(serverStatusToNodeState.get((Object)from.status));
        builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.publicAddress));
        builder.privateAddresses((Iterable)ImmutableSet.of((Object)from.privateAddress));
        builder.credentials(LoginCredentials.fromCredentials((Credentials)this.credentialStore.get(from.id + "")));
        return builder.build();
    }

    @Singleton
    public static class FindLocationForServer
    extends FindResourceInSet<Server, Location> {
        @Inject
        public FindLocationForServer(@Memoized Supplier<Set<? extends Location>> hardware) {
            super(hardware);
        }

        public boolean matches(Server from, Location input) {
            return input.getId().equals(from.datacenter + "");
        }
    }

    @Singleton
    public static class FindImageForServer
    extends FindResourceInSet<Server, Image> {
        @Inject
        public FindImageForServer(@Memoized Supplier<Set<? extends Image>> hardware) {
            super(hardware);
        }

        public boolean matches(Server from, Image input) {
            return input.getProviderId().equals(from.imageId + "");
        }
    }

    @Singleton
    public static class FindHardwareForServer
    extends FindResourceInSet<Server, Hardware> {
        @Inject
        public FindHardwareForServer(@Memoized Supplier<Set<? extends Hardware>> hardware) {
            super(hardware);
        }

        public boolean matches(Server from, Hardware input) {
            return input.getProviderId().equals(from.hardwareId + "");
        }
    }
}

