/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Credentials;
import org.jclouds.servermanager.Datacenter;
import org.jclouds.servermanager.Hardware;
import org.jclouds.servermanager.Image;
import org.jclouds.servermanager.Server;
import org.jclouds.servermanager.ServerManager;

@Singleton
public class ServerManagerComputeServiceAdapter
implements ComputeServiceAdapter<Server, Hardware, Image, Datacenter> {
    private final ServerManager client;

    @Inject
    public ServerManagerComputeServiceAdapter(ServerManager client) {
        this.client = (ServerManager)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public Server createNodeWithGroupEncodedIntoNameThenStoreCredentials(String tag, String name, Template template, Map<String, Credentials> credentialStore) {
        Server from = this.client.createServerInDC(template.getLocation().getId(), name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()));
        credentialStore.put(from.id + "", new Credentials(from.loginUser, from.password));
        return from;
    }

    public Iterable<Hardware> listHardwareProfiles() {
        return this.client.listHardware();
    }

    public Iterable<Image> listImages() {
        return this.client.listImages();
    }

    public Iterable<Server> listNodes() {
        return this.client.listServers();
    }

    public Iterable<Datacenter> listLocations() {
        return ImmutableSet.of((Object)new Datacenter(1, "SFO"));
    }

    public Server getNode(String id) {
        int serverId = Integer.parseInt(id);
        return this.client.getServer(serverId);
    }

    public void destroyNode(String id) {
        this.client.destroyServer(Integer.parseInt(id));
    }

    public void rebootNode(String id) {
        this.client.rebootServer(Integer.parseInt(id));
    }

    public void resumeNode(String id) {
        this.client.startServer(Integer.parseInt(id));
    }

    public void suspendNode(String id) {
        this.client.stopServer(Integer.parseInt(id));
    }
}

