/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.StandaloneComputeServiceContextSpec;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.servermanager.ServerManager;
import org.jclouds.servermanager.compute.ServerManagerComputeServiceContextBuilder;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class ServerManagerExperimentLiveTest {
    protected String provider = "servermanager";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;

    @BeforeClass
    protected void setupCredentials() {
        this.identity = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".identity"), (Object)("test." + this.provider + ".identity"));
        this.credential = System.getProperty("test." + this.provider + ".credential");
        this.endpoint = System.getProperty("test." + this.provider + ".endpoint");
        this.apiversion = System.getProperty("test." + this.provider + ".apiversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAndExperiment() {
        ComputeServiceContext context = null;
        try {
            context = new ComputeServiceContextFactory().createContext((RestContextSpec)new StandaloneComputeServiceContextSpec("servermanager", this.endpoint, this.apiversion, "", this.identity, this.credential, ServerManager.class, ServerManagerComputeServiceContextBuilder.class, (Iterable)ImmutableSet.of()));
            context.getComputeService().listNodes();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

