/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import java.util.Map;
import org.jclouds.domain.Credentials;
import org.jclouds.openstack.keystone.v2_0.AuthenticationApi;
import org.jclouds.openstack.keystone.v2_0.AuthenticationAsyncApi;
import org.jclouds.openstack.keystone.v2_0.config.CredentialTypes;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticatePasswordCredentials;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationApi;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationAsyncApi;
import org.jclouds.rackspace.cloudidentity.v2_0.functions.AuthenticateApiKeyCredentials;
import org.jclouds.rest.config.BinderUtils;

public class CloudIdentityAuthenticationModule
extends KeystoneAuthenticationModule {
    protected void bindAuthenticationApi() {
        BinderUtils.bindClientAndAsyncClient((Binder)this.binder(), CloudIdentityAuthenticationApi.class, CloudIdentityAuthenticationAsyncApi.class);
        this.bind(AuthenticationApi.class).to(CloudIdentityAuthenticationApi.class).in(Scopes.SINGLETON);
        this.bind(AuthenticationAsyncApi.class).to(CloudIdentityAuthenticationAsyncApi.class).in(Scopes.SINGLETON);
    }

    protected Map<String, Function<Credentials, Access>> authenticationMethods(Injector i) {
        ImmutableSet.Builder fns = ImmutableSet.builder();
        fns.add(i.getInstance(AuthenticatePasswordCredentials.class));
        fns.add(i.getInstance(AuthenticateApiKeyCredentials.class));
        return CredentialTypes.indexByCredentialType((Iterable)fns.build());
    }
}

