/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.compute.config.EC2ResolveImagesModule;
import org.jclouds.openstack.nova.ec2.NovaEC2AsyncClient;
import org.jclouds.openstack.nova.ec2.NovaEC2Client;
import org.jclouds.openstack.nova.ec2.config.HyphenToNullIso8601Module;
import org.jclouds.openstack.nova.ec2.config.NovaEC2ComputeServiceContextModule;
import org.jclouds.openstack.nova.ec2.config.NovaEC2RestClientModule;
import org.jclouds.rest.RestContext;

public class NovaEC2ApiMetadata
extends EC2ApiMetadata {
    private static final long serialVersionUID = -8539835226183747429L;
    public static final TypeToken<RestContext<NovaEC2Client, NovaEC2AsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<NovaEC2Client, NovaEC2AsyncClient>>(){
        private static final long serialVersionUID = -6449920293625658712L;
    };

    private static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NovaEC2ApiMetadata.builder().fromApiMetadata((ApiMetadata)this);
    }

    public NovaEC2ApiMetadata() {
        this(NovaEC2ApiMetadata.builder());
    }

    protected NovaEC2ApiMetadata(Builder builder) {
        super((EC2ApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = EC2ApiMetadata.defaultProperties();
        properties.setProperty("jclouds.regions", "nova");
        properties.setProperty("jclouds.ec2.ami-owners", "admin");
        properties.setProperty("jclouds.compute.resourcename-delimiter", "-");
        properties.setProperty("jclouds.relax-hostname", "true");
        properties.setProperty("jclouds.trust-all-certs", "true");
        properties.setProperty("jclouds.ec2.auto-allocate-elastic-ips", "true");
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        return properties;
    }

    public static class Builder
    extends EC2ApiMetadata.Builder {
        protected Builder() {
            super(NovaEC2Client.class, NovaEC2AsyncClient.class);
            this.id("openstack-nova-ec2").name("OpenStack Nova's EC2-clone API").version("2009-04-04").defaultEndpoint("http://localhost:8773/services/Cloud").defaultProperties(NovaEC2ApiMetadata.defaultProperties()).context(CONTEXT_TOKEN).defaultModules((Set)ImmutableSet.builder().add(NovaEC2RestClientModule.class).add(EC2ResolveImagesModule.class).add(NovaEC2ComputeServiceContextModule.class).add(HyphenToNullIso8601Module.class).build());
        }

        public NovaEC2ApiMetadata build() {
            return new NovaEC2ApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

