/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.strategy.EC2PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.xml.DescribeImagesResponseHandlerTest;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.ec2.strategy.NovaReviseParsedImage;
import org.jclouds.openstack.nova.v2_0.compute.functions.ImageToOperatingSystem;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NovaReviseParsedImageTest")
public class NovaReviseParsedImageTest {
    static Location defaultLocation = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();

    public void test() {
        Set<Image> result = NovaReviseParsedImageTest.convertImages("/nova_ec2_images.xml");
        Assert.assertEquals((int)result.size(), (int)7);
        Assert.assertEquals((String)((Image)Iterables.get(result, (int)4)).toString(), (String)new ImageBuilder().operatingSystem(OperatingSystem.builder().family(OsFamily.UBUNTU).arch("paravirtual").version("10.10").name("Ubuntu Maverick 10.10 Server 64-bit 20111212").description("Ubuntu Maverick 10.10 Server 64-bit 20111212").is64Bit(true).build()).name("Ubuntu Maverick 10.10 Server 64-bit 20111212").description("").defaultCredentials(new LoginCredentials("root", false)).id("us-east-1/ami-000004d6").providerId("ami-000004d6").location(defaultLocation).status(Image.Status.AVAILABLE).backendStatus("available").userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"", (Object)"rootDeviceType", (Object)"instance-store", (Object)"virtualizationType", (Object)"paravirtual", (Object)"hypervisor", (Object)"xen")).build().toString());
        Assert.assertEquals((Object)((Image)Iterables.get(result, (int)4)).getStatus(), (Object)Image.Status.AVAILABLE);
    }

    public static Set<Image> convertImages(String resource) {
        Map map = new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class));
        Set result = DescribeImagesResponseHandlerTest.parseImages((String)resource);
        EC2ImageParser parser = new EC2ImageParser(EC2ComputeServiceDependenciesModule.toPortableImageStatus, (PopulateDefaultLoginCredentialsForImageStrategy)new EC2PopulateDefaultLoginCredentialsForImageStrategy(), map, Suppliers.ofInstance((Object)ImmutableSet.of((Object)defaultLocation)), Suppliers.ofInstance((Object)defaultLocation), (ReviseParsedImage)new NovaReviseParsedImage((Function)new ImageToOperatingSystem(map)));
        return Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)result, (Function)parser), (Predicate)Predicates.notNull()));
    }
}

