/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.services;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.services.InstanceClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.ec2.NovaEC2Client;
import org.jclouds.openstack.nova.ec2.internal.BaseNovaEC2RestClientExpectTest;
import org.testng.Assert;

public class NovaEC2InstanceClientExpectTest
extends BaseNovaEC2RestClientExpectTest {
    public void testDescribeInstancesWithDashesInPlaceOfNullDates() {
        InstanceClient client = ((NovaEC2Client)this.requestsSendResponses(this.describeAvailabilityZonesRequest, this.describeAvailabilityZonesResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost:8773/services/Cloud/").addHeader("Host", new String[]{"localhost:8773"})).payload(NovaEC2InstanceClientExpectTest.payloadFromStringWithContentType((String)"Action=DescribeInstances&Signature=kkCE1HzyntmkICEidOizw50B9yjLdNZvAWUXVse1c8o%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2009-04-04&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/nova_ec2_describe_instances.xml"))).build())).getInstanceServices();
        Set response = client.describeInstancesInRegion("nova", new String[0]);
        Assert.assertEquals((int)response.size(), (int)3);
        Reservation target = (Reservation)Iterables.get((Iterable)response, (int)2);
        RunningInstance runningInstance = (RunningInstance)Iterables.getOnlyElement((Iterable)target);
        BlockDevice bd = (BlockDevice)Iterables.getOnlyElement(runningInstance.getEbsBlockDevices().values());
        Assert.assertNull((Object)bd.getAttachTime());
        Assert.assertFalse((boolean)bd.isDeleteOnTermination());
        Assert.assertEquals((String)bd.getVolumeId(), (String)"1");
    }
}

