/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.services;

import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.ec2.NovaEC2Client;
import org.jclouds.openstack.nova.ec2.internal.BaseNovaEC2RestClientExpectTest;
import org.jclouds.openstack.nova.ec2.services.NovaEC2KeyPairClient;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NovaEC2KeyPairClientExpectTest
extends BaseNovaEC2RestClientExpectTest {
    public void testImportKeyPair() {
        NovaEC2KeyPairClient client = ((NovaEC2Client)this.requestsSendResponses(this.describeAvailabilityZonesRequest, this.describeAvailabilityZonesResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost:8773/services/Cloud/").addHeader("Host", new String[]{"localhost:8773"})).payload(NovaEC2KeyPairClientExpectTest.payloadFromStringWithContentType((String)"Action=ImportKeyPair&KeyName=mykey&PublicKeyMaterial=c3NoLXJzYSBBQQ%3D%3D&Signature=wOOKOlDfJezRkx7NKcyOyaBQuY7PoVE3HFa9495RL7s%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2009-04-04&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/nova_ec2_import_keypair_response.xml"))).build())).getKeyPairServices();
        KeyPair result = client.importKeyPairInRegion(null, "mykey", "ssh-rsa AA");
        Assert.assertEquals((String)result.getKeyName(), (String)"aplowe-nova-ec22");
        Assert.assertEquals((String)result.getSha1OfPrivateKey(), (String)"e3:fd:de:f6:4c:36:7d:9b:8f:2f:4c:20:f8:ae:b0:ea");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testImportKeyPairFailsNotFound() {
        NovaEC2KeyPairClient client = ((NovaEC2Client)this.requestsSendResponses(this.describeAvailabilityZonesRequest, this.describeAvailabilityZonesResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost:8773/services/Cloud/").addHeader("Host", new String[]{"localhost:8773"})).payload(NovaEC2KeyPairClientExpectTest.payloadFromStringWithContentType((String)"Action=ImportKeyPair&KeyName=mykey&PublicKeyMaterial=c3NoLXJzYSBBQQ%3D%3D&Signature=wOOKOlDfJezRkx7NKcyOyaBQuY7PoVE3HFa9495RL7s%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2009-04-04&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), HttpResponse.builder().statusCode(404).build())).getKeyPairServices();
        client.importKeyPairInRegion(null, "mykey", "ssh-rsa AA");
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testImportKeyPairFailsAlreadyExists() {
        NovaEC2KeyPairClient client = ((NovaEC2Client)this.requestsSendResponses(this.describeAvailabilityZonesRequest, this.describeAvailabilityZonesResponse, ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost:8773/services/Cloud/").addHeader("Host", new String[]{"localhost:8773"})).payload(NovaEC2KeyPairClientExpectTest.payloadFromStringWithContentType((String)"Action=ImportKeyPair&KeyName=mykey&PublicKeyMaterial=c3NoLXJzYSBBQQ%3D%3D&Signature=wOOKOlDfJezRkx7NKcyOyaBQuY7PoVE3HFa9495RL7s%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2009-04-04&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), HttpResponse.builder().statusCode(409).build())).getKeyPairServices();
        client.importKeyPairInRegion(null, "mykey", "ssh-rsa AA");
    }
}

