/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.jclouds.filesystem.util.Utils;
import org.testng.Assert;

public class TestUtils {
    private static final String TARGET_RESOURCE_DIR = "." + File.separator + "target" + File.separator + "resources" + File.separator;
    private static final Iterable<File> IMAGE_RESOURCES = ImmutableList.of((Object)new File(TARGET_RESOURCE_DIR + "image1.jpg"), (Object)new File(TARGET_RESOURCE_DIR + "image2.jpg"), (Object)new File(TARGET_RESOURCE_DIR + "image3.jpg"), (Object)new File(TARGET_RESOURCE_DIR + "image4.jpg"));
    public static final String TARGET_BASE_DIR = "." + File.separator + "target" + File.separator + "basedir" + File.separator;
    private static final Iterator<File> IMAGE_RESOURCES_ITERATOR = Iterators.cycle(IMAGE_RESOURCES);

    public static String createRandomBlobKey() {
        return TestUtils.createRandomBlobKey("", "");
    }

    public static String createRandomBlobKey(String prefix, String extension) {
        String okPrefix = null != prefix && !"".equals(prefix) ? prefix : "testkey-";
        String okExtension = null != extension && !"".equals(extension) ? extension : ".jpg";
        return okPrefix + UUID.randomUUID().toString() + okExtension;
    }

    public static Set<String> createBlobsInContainer(String containerName, String ... blobNames) throws IOException {
        HashSet blobNamesCreatedInContainer = Sets.newHashSet();
        for (String blobName : blobNames) {
            TestUtils.createBlobAsFile(containerName, blobName, TestUtils.getImageForBlobPayload());
            blobNamesCreatedInContainer.add(blobName);
        }
        return blobNamesCreatedInContainer;
    }

    public static void createContainerAsDirectory(String containerName) throws IOException {
        File file = new File(TARGET_BASE_DIR, containerName);
        if (!file.mkdirs()) {
            throw new IOException("Could not mkdir: " + file);
        }
    }

    public static boolean directoryExists(String directoryFullPath) {
        File file = new File(directoryFullPath);
        boolean exists = file.exists() || file.isDirectory();
        return exists;
    }

    public static boolean directoryExists(String directoryFullPath, boolean expectedResult) {
        boolean exists = TestUtils.directoryExists(directoryFullPath);
        if (expectedResult) {
            Assert.assertTrue((boolean)exists, (String)("Directory " + directoryFullPath + " doens't exists"));
        } else {
            Assert.assertFalse((boolean)exists, (String)("Directory " + directoryFullPath + " still exists"));
        }
        return exists;
    }

    public static boolean fileExists(String fileFullName) {
        File file = new File(fileFullName);
        boolean exists = file.exists() || file.isFile();
        return exists;
    }

    public static boolean fileExists(String fileFullName, boolean expectedResult) {
        boolean exists = TestUtils.fileExists(fileFullName);
        if (expectedResult) {
            Assert.assertTrue((boolean)exists, (String)("File " + fileFullName + " doens't exists"));
        } else {
            Assert.assertFalse((boolean)exists, (String)("File " + fileFullName + " still exists"));
        }
        return exists;
    }

    public static void cleanDirectoryContent(String directoryName) throws IOException {
        File parentDirectory = new File(directoryName);
        File[] children = parentDirectory.listFiles();
        if (null != children) {
            for (File child : children) {
                Utils.deleteRecursively((File)child);
            }
        }
    }

    public static void createBlobAsFile(String containerName, String blobKey, File source) throws IOException {
        String filePath = blobKey.startsWith("\\") ? containerName + blobKey : containerName + File.separator + blobKey;
        File file = new File(TARGET_BASE_DIR + filePath);
        Files.createParentDirs((File)file);
        Files.copy((File)source, (File)file);
    }

    public static File getImageForBlobPayload() {
        return IMAGE_RESOURCES_ITERATOR.next();
    }

    public static void createResources() throws IOException {
        File resourceDir = new File(TARGET_RESOURCE_DIR);
        if (resourceDir.exists()) {
            Utils.deleteRecursively((File)resourceDir);
        }
        if (!resourceDir.mkdir()) {
            throw new IOException("Could not create: " + TARGET_RESOURCE_DIR);
        }
        Random random = new Random();
        for (File file : IMAGE_RESOURCES) {
            byte[] buffer = new byte[random.nextInt(0x200000)];
            random.nextBytes(buffer);
            Files.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])buffer), (File)file);
        }
    }
}

