/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.integration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Properties;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.integration.internal.BaseContainerIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.filesystem.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"}, testName="blobstore.FilesystemContainerIntegrationTest")
public class FilesystemContainerIntegrationTestDisabled
extends BaseContainerIntegrationTest {
    public FilesystemContainerIntegrationTestDisabled() {
        this.provider = "filesystem";
        BaseBlobStoreIntegrationTest.SANITY_CHECK_RETURNED_BUCKET_NAME = true;
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.setProperty("jclouds.filesystem.basedir", TestUtils.TARGET_BASE_DIR);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testNotWithDetails() throws InterruptedException {
        String key = "hello";
        Blob object = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").build();
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, object);
            this.validateContent(containerName, key);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1));
            BlobMetadata metadata = (BlobMetadata)Iterables.getOnlyElement((Iterable)container);
            Assert.assertEquals((int)metadata.getUserMetadata().size(), (int)0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

