/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.MutableStorageMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.HttpGetOptionsListToGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.strategy.FilesystemStorageStrategy;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ParamValidators;

public class FilesystemAsyncBlobStore
extends BaseAsyncBlobStore {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    protected final Crypto crypto;
    protected final HttpGetOptionsListToGetOptions httpGetOptionsConverter;
    protected final ContentMetadataCodec contentMetadataCodec;
    protected final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    protected final Blob.Factory blobFactory;
    protected final FilesystemStorageStrategy storageStrategy;

    @Inject
    protected FilesystemAsyncBlobStore(BlobStoreContext context, DateService dateService, Crypto crypto, HttpGetOptionsListToGetOptions httpGetOptionsConverter, ContentMetadataCodec contentMetadataCodec, IfDirectoryReturnNameStrategy ifDirectoryReturnName, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, Blob.Factory blobFactory, FilesystemStorageStrategy storageStrategy) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.blobFactory = blobFactory;
        this.dateService = dateService;
        this.crypto = crypto;
        this.httpGetOptionsConverter = httpGetOptionsConverter;
        this.contentMetadataCodec = contentMetadataCodec;
        this.ifDirectoryReturnName = ifDirectoryReturnName;
        this.storageStrategy = (FilesystemStorageStrategy)Preconditions.checkNotNull((Object)storageStrategy, (Object)"Storage strategy");
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list(final String container, ListContainerOptions options) {
        if (!this.storageStrategy.containerExists(container)) {
            return Futures.immediateFailedFuture((Throwable)this.cnfe(container));
        }
        Iterable<String> blobBelongingToContainer = null;
        try {
            blobBelongingToContainer = this.storageStrategy.getBlobKeysInsideContainer(container);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred loading blobs contained into container %s", new Object[]{container});
            Throwables.propagate((Throwable)e);
        }
        SortedSet<Object> contents = Sets.newTreeSet((Iterable)Iterables.transform(blobBelongingToContainer, (Function)new Function<String, StorageMetadata>(){

            public StorageMetadata apply(String key) {
                Blob oldBlob = FilesystemAsyncBlobStore.this.loadBlob(container, key);
                Preconditions.checkState((oldBlob != null ? 1 : 0) != 0, (Object)("blob " + key + " is not present although it was in the list of " + container));
                Preconditions.checkState((oldBlob.getMetadata() != null ? 1 : 0) != 0, (Object)("blob " + container + "/" + key + " has no metadata"));
                MutableBlobMetadata md = FilesystemAsyncBlobStore.copy(oldBlob.getMetadata());
                String directoryName = FilesystemAsyncBlobStore.this.ifDirectoryReturnName.execute((StorageMetadata)md);
                if (directoryName != null) {
                    md.setName(directoryName);
                    md.setType((Enum)StorageType.RELATIVE_PATH);
                }
                return md;
            }
        }));
        String marker = null;
        if (options != null) {
            String delimiter;
            int maxResults;
            String prefix;
            if (options.getMarker() != null) {
                final String finalMarker = options.getMarker();
                StorageMetadata lastMarkerMetadata = (StorageMetadata)Iterables.find((Iterable)contents, (Predicate)new Predicate<StorageMetadata>(){

                    public boolean apply(StorageMetadata metadata) {
                        return metadata.getName().compareTo(finalMarker) > 0;
                    }
                });
                contents = contents.tailSet(lastMarkerMetadata);
            }
            if ((prefix = options.getDir()) != null) {
                contents = Sets.newTreeSet((Iterable)Sets.filter((SortedSet)contents, (Predicate)new Predicate<StorageMetadata>(){

                    public boolean apply(StorageMetadata o) {
                        return o != null && o.getName().startsWith(prefix) && !o.getName().equals(prefix);
                    }
                }));
            }
            int n = maxResults = options.getMaxResults() != null ? options.getMaxResults() : 1000;
            if (!contents.isEmpty()) {
                StorageMetadata lastElement = (StorageMetadata)contents.last();
                if (!(contents = Sets.newTreeSet((Iterable)Iterables.limit((Iterable)contents, (int)maxResults))).contains(lastElement)) {
                    marker = ((StorageMetadata)contents.last()).getName();
                }
            }
            String string = delimiter = options.isRecursive() ? null : File.separator;
            if (delimiter != null) {
                TreeSet commonPrefixes = Sets.newTreeSet((Iterable)Iterables.transform(contents, (Function)new CommonPrefixes(prefix, delimiter)));
                commonPrefixes.remove("NO_PREFIX");
                contents = Sets.newTreeSet((Iterable)Sets.filter(contents, (Predicate)new DelimiterFilter(prefix, delimiter)));
                Iterables.addAll(contents, (Iterable)Iterables.transform((Iterable)commonPrefixes, (Function)new Function<String, StorageMetadata>(){

                    public StorageMetadata apply(String o) {
                        MutableStorageMetadataImpl md = new MutableStorageMetadataImpl();
                        md.setType((Enum)StorageType.RELATIVE_PATH);
                        md.setName(o);
                        return md;
                    }
                }));
            }
            if (!options.isDetailed()) {
                for (StorageMetadata storageMetadata : contents) {
                    storageMetadata.getUserMetadata().clear();
                }
            }
        }
        return Futures.immediateFuture((Object)new PageSetImpl((Iterable)contents, marker));
    }

    private ContainerNotFoundException cnfe(String name) {
        return new ContainerNotFoundException(name, String.format("container %s not in %s", name, this.storageStrategy.getAllContainerNames()));
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bout);
            os.writeObject(in);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
            MutableBlobMetadata metadata = (MutableBlobMetadata)is.readObject();
            FilesystemAsyncBlobStore.convertUserMetadataKeysToLowercase(metadata);
            metadata.setContentMetadata((MutableContentMetadata)BaseMutableContentMetadata.fromContentMetadata((ContentMetadata)in.getContentMetadata().toBuilder().build()));
            return metadata;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void convertUserMetadataKeysToLowercase(MutableBlobMetadata metadata) {
        HashMap lowerCaseUserMetadata = Maps.newHashMap();
        for (Map.Entry entry : metadata.getUserMetadata().entrySet()) {
            lowerCaseUserMetadata.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
        metadata.setUserMetadata((Map)lowerCaseUserMetadata);
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in, String newKey) {
        MutableBlobMetadata newMd = FilesystemAsyncBlobStore.copy(in);
        newMd.setName(newKey);
        return newMd;
    }

    public ListenableFuture<Void> removeBlob(String container, String key) {
        this.storageStrategy.removeBlob(container, key);
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> deleteContainer(String container) {
        this.deleteAndVerifyContainerGone(container);
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Boolean> containerExists(String containerName) {
        return Futures.immediateFuture((Object)this.storageStrategy.containerExists(containerName));
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        Iterable<String> containers = this.storageStrategy.getAllContainerNames();
        return Futures.immediateFuture((Object)new PageSetImpl(Iterables.transform(containers, (Function)new Function<String, StorageMetadata>(){

            public StorageMetadata apply(String name) {
                MutableStorageMetadata cmd = FilesystemAsyncBlobStore.this.create();
                cmd.setName(name);
                cmd.setType((Enum)StorageType.CONTAINER);
                return cmd;
            }
        }), null));
    }

    protected MutableStorageMetadata create() {
        return new MutableStorageMetadataImpl();
    }

    @Path(value="{container}")
    public ListenableFuture<Boolean> createContainerInLocation(Location location, @PathParam(value="container") @ParamValidators(value={FilesystemContainerNameValidator.class}) String name) {
        boolean result = this.storageStrategy.createContainer(name);
        return Futures.immediateFuture((Object)result);
    }

    private Blob loadBlob(String container, String key) {
        this.logger.debug("Opening blob in container: %s - %s", new Object[]{container, key});
        return this.storageStrategy.getBlob(container, key);
    }

    public static HttpResponseException returnResponseException(int code) {
        HttpResponse response = null;
        response = new HttpResponse(code, null, null);
        return new HttpResponseException(new HttpCommand(){

            public int getRedirectCount() {
                return 0;
            }

            public int incrementRedirectCount() {
                return 0;
            }

            public boolean isReplayable() {
                return false;
            }

            public Exception getException() {
                return null;
            }

            public int getFailureCount() {
                return 0;
            }

            public int incrementFailureCount() {
                return 0;
            }

            public void setException(Exception exception) {
            }

            public HttpRequest getCurrentRequest() {
                return new HttpRequest("GET", URI.create("http://stub"));
            }

            public void setCurrentRequest(HttpRequest request) {
            }
        }, response);
    }

    public ListenableFuture<String> putBlob(String containerName, Blob blob) {
        Preconditions.checkNotNull((Object)containerName, (Object)"containerName must be set");
        Preconditions.checkNotNull((Object)blob, (Object)"blob must be set");
        String blobKey = blob.getMetadata().getName();
        this.logger.debug("Put blob with key [%s] to container [%s]", new Object[]{blobKey, containerName});
        String eTag = this.getEtag(blob);
        try {
            this.storageStrategy.writePayloadOnFile(containerName, blobKey, blob.getPayload());
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred storing the new blob with name [%s] to container [%s].", new Object[]{blobKey, containerName});
            Throwables.propagate((Throwable)e);
        }
        return Futures.immediateFuture((Object)eTag);
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(this.contentMetadataCodec.toHeaders((ContentMetadata)payload.getContentMetadata()));
    }

    public ListenableFuture<Boolean> blobExists(String containerName, String key) {
        if (!this.storageStrategy.containerExists(containerName)) {
            return Futures.immediateFailedFuture((Throwable)this.cnfe(containerName));
        }
        return Futures.immediateFuture((Object)this.storageStrategy.blobExists(containerName, key));
    }

    public ListenableFuture<Blob> getBlob(String containerName, String key, GetOptions options) {
        this.logger.debug("Retrieving blob with key %s from container %s", new Object[]{key, containerName});
        if (!this.storageStrategy.containerExists(containerName)) {
            this.logger.debug("Container %s does not exist", new Object[]{containerName});
            return Futures.immediateFailedFuture((Throwable)this.cnfe(containerName));
        }
        if (!this.storageStrategy.blobExists(containerName, key)) {
            this.logger.debug("Item %s does not exist in container %s", new Object[]{key, containerName});
            return Futures.immediateFuture(null);
        }
        Blob blob = this.loadBlob(containerName, key);
        if (options != null) {
            if (options.getIfMatch() != null && !blob.getMetadata().getETag().equals(options.getIfMatch())) {
                return Futures.immediateFailedFuture((Throwable)FilesystemAsyncBlobStore.returnResponseException(412));
            }
            if (options.getIfNoneMatch() != null && blob.getMetadata().getETag().equals(options.getIfNoneMatch())) {
                return Futures.immediateFailedFuture((Throwable)FilesystemAsyncBlobStore.returnResponseException(304));
            }
            if (options.getIfModifiedSince() != null) {
                Date modifiedSince = options.getIfModifiedSince();
                if (blob.getMetadata().getLastModified().before(modifiedSince)) {
                    HttpResponse response = new HttpResponse(304, null, null);
                    return Futures.immediateFailedFuture((Throwable)new HttpResponseException(String.format("%1$s is before %2$s", blob.getMetadata().getLastModified(), modifiedSince), null, response));
                }
            }
            if (options.getIfUnmodifiedSince() != null) {
                Date unmodifiedSince = options.getIfUnmodifiedSince();
                if (blob.getMetadata().getLastModified().after(unmodifiedSince)) {
                    HttpResponse response = new HttpResponse(412, null, null);
                    return Futures.immediateFailedFuture((Throwable)new HttpResponseException(String.format("%1$s is after %2$s", blob.getMetadata().getLastModified(), unmodifiedSince), null, response));
                }
            }
            blob = this.copyBlob(blob);
            if (options.getRanges() != null && options.getRanges().size() > 0) {
                byte[] data;
                try {
                    data = ByteStreams.toByteArray((InputStream)blob.getPayload().getInput());
                }
                catch (IOException e) {
                    return Futures.immediateFailedFuture((Throwable)new RuntimeException(e));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (String s : options.getRanges()) {
                    int offset = 0;
                    int last = data.length - 1;
                    if (s.startsWith("-")) {
                        offset = last - Integer.parseInt(s.substring(1)) + 1;
                    } else if (s.endsWith("-")) {
                        offset = Integer.parseInt(s.substring(0, s.length() - 1));
                    } else if (s.contains("-")) {
                        String[] firstLast = s.split("\\-");
                        offset = Integer.parseInt(firstLast[0]);
                        last = Integer.parseInt(firstLast[1]);
                    } else {
                        return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("illegal range: " + s));
                    }
                    if (offset > last) {
                        return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("illegal range: " + s));
                    }
                    if (last + 1 > data.length) {
                        last = data.length - 1;
                    }
                    out.write(data, offset, last - offset + 1);
                }
                MutableContentMetadata cmd = blob.getPayload().getContentMetadata();
                byte[] byteArray = out.toByteArray();
                blob.setPayload(byteArray);
                HttpUtils.copy((ContentMetadata)cmd, (MutableContentMetadata)blob.getPayload().getContentMetadata());
                blob.getPayload().getContentMetadata().setContentLength(new Long(byteArray.length));
            }
        }
        Preconditions.checkNotNull((Object)blob.getPayload(), (Object)("payload " + blob));
        return Futures.immediateFuture((Object)blob);
    }

    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        try {
            Blob blob = (Blob)this.getBlob(container, key).get();
            return Futures.immediateFuture(blob != null ? FilesystemAsyncBlobStore.copy(blob.getMetadata()) : null);
        }
        catch (Exception e) {
            if (Iterables.size((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), KeyNotFoundException.class)) >= 1) {
                return Futures.immediateFuture(null);
            }
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private Blob copyBlob(Blob blob) {
        Blob returnVal = this.blobFactory.create(FilesystemAsyncBlobStore.copy(blob.getMetadata()));
        returnVal.setPayload(blob.getPayload());
        this.copyPayloadHeadersToBlob(blob.getPayload(), returnVal);
        return returnVal;
    }

    private String getEtag(Blob object) {
        try {
            Payloads.calculateMD5((PayloadEnclosing)object, (MessageDigest)this.crypto.md5());
        }
        catch (IOException ex) {
            this.logger.error((Throwable)ex, "An error occurred calculating MD5 for object with name %s.", new Object[]{object.getMetadata().getName()});
            Throwables.propagate((Throwable)ex);
        }
        String eTag = CryptoStreams.hex((byte[])object.getPayload().getContentMetadata().getContentMD5());
        return eTag;
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.storageStrategy.deleteContainer(container);
        return this.storageStrategy.containerExists(container);
    }

    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            throw new UnsupportedOperationException("publicRead");
        }
        return this.createContainerInLocation(location, container);
    }

    protected static class CommonPrefixes
    implements Function<StorageMetadata, String> {
        private final String prefix;
        private final String delimiter;
        public static final String NO_PREFIX = "NO_PREFIX";

        public CommonPrefixes(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        public String apply(StorageMetadata metadata) {
            String working = metadata.getName();
            if (this.prefix != null) {
                String toMatch;
                String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
                if (working.startsWith(toMatch)) {
                    working = working.replaceFirst(toMatch, "");
                }
            }
            if (working.contains(this.delimiter)) {
                return working.substring(0, working.indexOf(this.delimiter));
            }
            return NO_PREFIX;
        }
    }

    protected static class DelimiterFilter
    implements Predicate<StorageMetadata> {
        private final String prefix;
        private final String delimiter;

        public DelimiterFilter(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        public boolean apply(StorageMetadata metadata) {
            String toMatch;
            if (this.prefix == null) {
                return metadata.getName().indexOf(this.delimiter) == -1;
            }
            String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
            if (metadata.getName().startsWith(toMatch)) {
                String unprefixedName = metadata.getName().replaceFirst(toMatch, "");
                if (unprefixedName.equals("")) {
                    return false;
                }
                return unprefixedName.indexOf(this.delimiter) == -1;
            }
            return false;
        }
    }
}

