/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.inject.CreationException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.filesystem.utils.TestUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.InputSuppliers;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.PhantomPayload;
import org.jclouds.io.payloads.StringPayload;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="filesystem.FilesystemAsyncBlobStoreTest", singleThreaded=true)
public class FilesystemAsyncBlobStoreTest {
    private static final String CONTAINER_NAME = "fun-blobstore-test";
    private static final String TARGET_CONTAINER_NAME = TestUtils.TARGET_BASE_DIR + "fun-blobstore-test";
    private static final String LOGGING_CONFIG_KEY = "java.util.logging.config.file";
    private static final String LOGGING_CONFIG_VALUE = "src/main/resources/logging.properties";
    private static final String PROVIDER = "filesystem";
    private BlobStoreContext context = null;
    private BlobStore blobStore = null;
    private Set<File> resourcesToBeDeleted = new HashSet<File>();

    @BeforeMethod
    protected void setUp() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("jclouds.filesystem.basedir", TestUtils.TARGET_BASE_DIR);
        this.context = (BlobStoreContext)ContextBuilder.newBuilder((String)PROVIDER).overrides(prop).build(BlobStoreContext.class);
        this.blobStore = this.context.getBlobStore();
        this.resourcesToBeDeleted.add(new File(TestUtils.TARGET_BASE_DIR));
    }

    @AfterMethod
    protected void tearDown() {
        this.context.close();
        this.context = null;
        Iterator<File> resourceToDelete = this.resourcesToBeDeleted.iterator();
        while (resourceToDelete.hasNext()) {
            File fileToDelete = resourceToDelete.next();
            try {
                FileUtils.forceDelete((File)fileToDelete);
            }
            catch (IOException ex) {
                System.err.println("Error deleting folder [" + fileToDelete.getName() + "].");
            }
            resourceToDelete.remove();
        }
    }

    @DataProvider
    public Object[][] ignoreOnWindows() {
        return TestUtils.isWindowsOs() ? TestUtils.NO_INVOCATIONS : TestUtils.SINGLE_NO_ARG_INVOCATION;
    }

    public void testParameters() {
        Properties props;
        try {
            props = new Properties();
            this.context = (BlobStoreContext)ContextBuilder.newBuilder((String)PROVIDER).overrides(props).build(BlobStoreContext.class);
            org.testng.Assert.fail((String)"No error if base directory is not specified");
        }
        catch (CreationException e) {
            // empty catch block
        }
        try {
            props = new Properties();
            props.setProperty("jclouds.filesystem.basedir", null);
            this.context = (BlobStoreContext)ContextBuilder.newBuilder((String)PROVIDER).overrides(props).build(BlobStoreContext.class);
            org.testng.Assert.fail((String)"No error if base directory is null in the option");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testList_Root() throws IOException {
        HashSet<String> containersCreated = new HashSet<String>();
        PageSet containersRetrieved = this.blobStore.list();
        org.testng.Assert.assertTrue((boolean)containersRetrieved.isEmpty(), (String)"List operation returns a not empty set of container");
        String[] containerNames = new String[]{"34343", "aaaa", "bbbbb"};
        containersCreated = new HashSet();
        for (String containerName : containerNames) {
            this.blobStore.createContainerInLocation(null, containerName);
            containersCreated.add(containerName);
        }
        containersRetrieved = this.blobStore.list();
        org.testng.Assert.assertEquals((int)containersCreated.size(), (int)containersRetrieved.size(), (String)"Different numbers of container");
        for (StorageMetadata data : containersRetrieved) {
            String containerName = data.getName();
            if (containersCreated.remove(containerName)) continue;
            org.testng.Assert.fail((String)("Container list contains unexpected value [" + containerName + "]"));
        }
        org.testng.Assert.assertTrue((boolean)containersCreated.isEmpty(), (String)"List operation doesn't return all values.");
        for (String containerName : containerNames) {
            this.blobStore.deleteContainer(containerName);
        }
        containersRetrieved = this.blobStore.list();
        org.testng.Assert.assertTrue((boolean)containersRetrieved.isEmpty(), (String)"List operation returns a not empty set of container");
    }

    public void testList_NoOptionSingleContainer() throws IOException {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.checkForContainerContent(CONTAINER_NAME, null);
        Set<String> blobsExpected = TestUtils.createBlobsInContainer(CONTAINER_NAME, "bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg", "4rrr.jpg", "rrr" + File.separator + "sss" + File.separator + "788.jpg", "xdc" + File.separator + "wert.kpg");
        this.checkForContainerContent(CONTAINER_NAME, blobsExpected);
    }

    public void testList_NotExistingContainer() {
        try {
            this.blobStore.list(CONTAINER_NAME);
            org.testng.Assert.fail((String)"Found a not existing container");
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
    }

    public void testList_NoOptionDoubleContainer() throws IOException {
        String CONTAINER_NAME2 = "container2";
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.checkForContainerContent(CONTAINER_NAME, null);
        this.blobStore.createContainerInLocation(null, "container2");
        this.checkForContainerContent("container2", null);
        Set<String> blobNamesCreatedInContainer1 = TestUtils.createBlobsInContainer(CONTAINER_NAME, "bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg", TestUtils.createRandomBlobKey(), "rrr" + File.separator + "sss" + File.separator + "788.jpg", "xdc" + File.separator + "wert.kpg");
        this.blobStore.createContainerInLocation(null, "container2");
        Set<String> blobNamesCreatedInContainer2 = TestUtils.createBlobsInContainer("container2", "asd" + File.separator + "bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg", TestUtils.createRandomBlobKey(), "rrr" + File.separator + "sss" + File.separator + "788.jpg", "xdc" + File.separator + "wert.kpg");
        this.checkForContainerContent(CONTAINER_NAME, blobNamesCreatedInContainer1);
        this.checkForContainerContent("container2", blobNamesCreatedInContainer2);
    }

    public void testList_Subdirectory() throws IOException {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.checkForContainerContent(CONTAINER_NAME, null);
        Set<String> blobsExpected = TestUtils.createBlobsInContainer(CONTAINER_NAME, "bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg", "4rrr.jpg", "rrr" + File.separator + "sss" + File.separator + "788.jpg", "rrr" + File.separator + "wert.kpg");
        blobsExpected.remove("bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg");
        blobsExpected.remove("4rrr.jpg");
        this.checkForContainerContent(CONTAINER_NAME, "rrr", blobsExpected);
    }

    public void testClearContainer_NotExistingContainer() {
        this.blobStore.clearContainer(CONTAINER_NAME);
    }

    public void testClearContainer_NoOptions() throws IOException {
        String CONTAINER_NAME2 = "containerToClear";
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.blobStore.createContainerInLocation(null, "containerToClear");
        Set<String> blobNamesCreatedInContainer1 = TestUtils.createBlobsInContainer(CONTAINER_NAME, "bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg", TestUtils.createRandomBlobKey(), "rrr" + File.separator + "sss" + File.separator + "788.jpg", "xdc" + File.separator + "wert.kpg");
        this.blobStore.createContainerInLocation(null, "containerToClear");
        Set<String> blobNamesCreatedInContainer2 = TestUtils.createBlobsInContainer("containerToClear", "asd" + File.separator + "bbb" + File.separator + "ccc" + File.separator + "ddd" + File.separator + "1234.jpg", TestUtils.createRandomBlobKey(), "rrr" + File.separator + "sss" + File.separator + "788.jpg", "xdc" + File.separator + "wert.kpg");
        this.checkForContainerContent(CONTAINER_NAME, blobNamesCreatedInContainer1);
        this.checkForContainerContent("containerToClear", blobNamesCreatedInContainer2);
        this.blobStore.clearContainer(CONTAINER_NAME);
        this.checkForContainerContent(CONTAINER_NAME, null);
        this.checkForContainerContent("containerToClear", blobNamesCreatedInContainer2);
        this.blobStore.clearContainer("containerToClear");
        this.checkForContainerContent("containerToClear", null);
    }

    public void testCountBlobs_NotExistingContainer() {
        try {
            this.blobStore.countBlobs(PROVIDER);
            org.testng.Assert.fail((String)"Magically the method was implemented... Wow!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testCountBlobs_NoOptionsEmptyContainer() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        try {
            this.blobStore.countBlobs(PROVIDER);
            org.testng.Assert.fail((String)"Magically the method was implemented... Wow!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testCountBlobs_NoOptions() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        try {
            this.blobStore.countBlobs(PROVIDER);
            org.testng.Assert.fail((String)"Magically the method was implemented... Wow!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveBlob_SimpleBlobKey() throws IOException {
        String BLOB_KEY = TestUtils.createRandomBlobKey(null, ".txt");
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        boolean result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob exists");
        TestUtils.createBlobsInContainer(CONTAINER_NAME, BLOB_KEY);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertTrue((boolean)result, (String)"Blob exists");
        this.blobStore.removeBlob(CONTAINER_NAME, BLOB_KEY);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob still exists");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY, false);
    }

    public void testRemoveBlob_TwoSimpleBlobKeys() throws IOException {
        String BLOB_KEY1 = TestUtils.createRandomBlobKey(null, null);
        String BLOB_KEY2 = TestUtils.createRandomBlobKey(null, null);
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        boolean result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY1);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob1 exists");
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob2 exists");
        TestUtils.createBlobsInContainer(CONTAINER_NAME, BLOB_KEY1, BLOB_KEY2);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY1);
        org.testng.Assert.assertTrue((boolean)result, (String)("Blob " + BLOB_KEY1 + " doesn't exist"));
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertTrue((boolean)result, (String)("Blob " + BLOB_KEY2 + " doesn't exist"));
        this.blobStore.removeBlob(CONTAINER_NAME, BLOB_KEY1);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY1);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob1 still exists");
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertTrue((boolean)result, (String)"Blob2 doesn't exist");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY1, false);
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY2, true);
        this.blobStore.removeBlob(CONTAINER_NAME, BLOB_KEY2);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob2 still exists");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY2, false);
    }

    @Test(dataProvider="ignoreOnWindows", description="see http://code.google.com/p/jclouds/issues/detail?id=737")
    public void testRemoveBlob_ComplexBlobKey() throws IOException {
        String BLOB_KEY = TestUtils.createRandomBlobKey("aa/bb/cc/dd/", null);
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        boolean result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob exists");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY, false);
        TestUtils.createBlobsInContainer(CONTAINER_NAME, BLOB_KEY);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertTrue((boolean)result, (String)"Blob doesn't exist");
        this.blobStore.removeBlob(CONTAINER_NAME, BLOB_KEY);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob still exists");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY, false);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + "/aa", false);
    }

    @Test(dataProvider="ignoreOnWindows", description="see http://code.google.com/p/jclouds/issues/detail?id=737")
    public void testRemoveBlob_TwoComplexBlobKeys() throws IOException {
        String BLOB_KEY1 = TestUtils.createRandomBlobKey("aa/bb/cc/dd/", null);
        String BLOB_KEY2 = TestUtils.createRandomBlobKey("aa/bb/ee/ff/", null);
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        boolean result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY1);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob1 exists");
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob2 exists");
        TestUtils.createBlobsInContainer(CONTAINER_NAME, BLOB_KEY1, BLOB_KEY2);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY1);
        org.testng.Assert.assertTrue((boolean)result, (String)("Blob " + BLOB_KEY1 + " doesn't exist"));
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertTrue((boolean)result, (String)("Blob " + BLOB_KEY2 + " doesn't exist"));
        this.blobStore.removeBlob(CONTAINER_NAME, BLOB_KEY1);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY1);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob still exists");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY1, false);
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY2, true);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + "/aa/bb/cc/dd", false);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + "/aa/bb", true);
        this.blobStore.removeBlob(CONTAINER_NAME, BLOB_KEY2);
        result = this.blobStore.blobExists(CONTAINER_NAME, BLOB_KEY2);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob still exists");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY2, false);
        TestUtils.directoryExists(TARGET_CONTAINER_NAME + "/aa", false);
    }

    public void testContainerExists() throws IOException {
        boolean result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertFalse((boolean)result, (String)"Container exists");
        TestUtils.createContainerAsDirectory(CONTAINER_NAME);
        result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertTrue((boolean)result, (String)"Container doesn't exist");
    }

    public void testCreateContainerInLocation() throws IOException {
        String CONTAINER_NAME2 = "funambol-test-2";
        String TARGET_CONTAINER_NAME2 = TestUtils.TARGET_BASE_DIR + "funambol-test-2";
        boolean result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertFalse((boolean)result, (String)"Container exists");
        result = this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        org.testng.Assert.assertTrue((boolean)result, (String)"Container not created");
        result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertTrue((boolean)result, (String)"Container doesn't exist");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        result = this.blobStore.containerExists("funambol-test-2");
        org.testng.Assert.assertFalse((boolean)result, (String)"Container exists");
        result = this.blobStore.createContainerInLocation(null, "funambol-test-2");
        org.testng.Assert.assertTrue((boolean)result, (String)"Container not created");
        result = this.blobStore.containerExists("funambol-test-2");
        org.testng.Assert.assertTrue((boolean)result, (String)"Container doesn't exist");
        TestUtils.directoryExists(TestUtils.TARGET_BASE_DIR + "funambol-test-2", true);
        FileUtils.forceDelete((File)new File(TARGET_CONTAINER_NAME2));
    }

    public void testPutBlobSimpleName() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("putBlob-", ".jpg"));
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("putBlob-", ".jpg"));
    }

    public void testPutBlobComplexName1() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("picture/putBlob-", ".jpg"));
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("video/putBlob-", ".jpg"));
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("putBlob-", ".jpg"));
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("video/putBlob-", ".jpg"));
    }

    public void testPutBlobComplexName2() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("aa/bb/cc/dd/ee/putBlob-", ".jpg"));
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("aa/bb/cc/dd/ee/putBlob-", ".jpg"));
        this.putBlobAndCheckIt(TestUtils.createRandomBlobKey("putBlob-", ".jpg"));
    }

    public void testBlobExists() throws IOException {
        String blobKey = TestUtils.createRandomBlobKey();
        try {
            this.blobStore.blobExists(CONTAINER_NAME, blobKey);
            org.testng.Assert.fail();
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        boolean result = this.blobStore.blobExists(CONTAINER_NAME, blobKey);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob exists");
        TestUtils.createBlobAsFile(CONTAINER_NAME, blobKey, TestUtils.getImageForBlobPayload());
        result = this.blobStore.blobExists(CONTAINER_NAME, blobKey);
        org.testng.Assert.assertTrue((boolean)result, (String)"Blob doesn't exist");
        blobKey = TestUtils.createRandomBlobKey("ss/asdas/", "");
        result = this.blobStore.blobExists(CONTAINER_NAME, blobKey);
        org.testng.Assert.assertFalse((boolean)result, (String)"Blob exists");
        TestUtils.createBlobAsFile(CONTAINER_NAME, blobKey, TestUtils.getImageForBlobPayload());
        result = this.blobStore.blobExists(CONTAINER_NAME, blobKey);
        org.testng.Assert.assertTrue((boolean)result, (String)"Blob doesn't exist");
    }

    public void testGetBlob_NotExistingContainer() {
        try {
            this.blobStore.getBlob(CONTAINER_NAME, TestUtils.createRandomBlobKey(), null);
            org.testng.Assert.fail((String)"Retrieve must fail, container does not exist.");
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
    }

    public void testGetBlob() throws IOException {
        String blobKey = TestUtils.createRandomBlobKey();
        GetOptions options = null;
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        Blob resultBlob = this.blobStore.getBlob(CONTAINER_NAME, blobKey, options);
        org.testng.Assert.assertNull((Object)resultBlob, (String)"Blob exists");
        TestUtils.createBlobsInContainer(CONTAINER_NAME, blobKey);
        resultBlob = this.blobStore.getBlob(CONTAINER_NAME, blobKey, options);
        org.testng.Assert.assertNotNull((Object)resultBlob, (String)"Blob exists");
        InputSupplier expectedFile = Files.newInputStreamSupplier((File)new File(TARGET_CONTAINER_NAME, blobKey));
        InputSupplier actualFile = InputSuppliers.of((InputStream)resultBlob.getPayload().getInput());
        org.testng.Assert.assertTrue((boolean)ByteStreams.equal((InputSupplier)expectedFile, (InputSupplier)actualFile), (String)"Blob payload differs from file content");
        org.testng.Assert.assertNotNull((Object)resultBlob.getMetadata(), (String)"Metadata null");
        MutableBlobMetadata metadata = resultBlob.getMetadata();
        org.testng.Assert.assertEquals((String)blobKey, (String)metadata.getName(), (String)"Wrong blob metadata");
    }

    public void testBlobMetadata_withDefaultMetadata() throws IOException {
        String BLOB_KEY = TestUtils.createRandomBlobKey(null, null);
        TestUtils.createBlobsInContainer(CONTAINER_NAME, BLOB_KEY);
        BlobMetadata metadata = this.blobStore.blobMetadata(CONTAINER_NAME, BLOB_KEY);
        org.testng.Assert.assertNotNull((Object)metadata, (String)"Metadata null");
        org.testng.Assert.assertEquals((String)metadata.getName(), (String)BLOB_KEY, (String)"Wrong blob name");
        org.testng.Assert.assertEquals((Object)metadata.getType(), (Object)StorageType.BLOB, (String)"Wrong blob type");
        org.testng.Assert.assertEquals((String)metadata.getContentMetadata().getContentType(), (String)"application/unknown", (String)"Wrong blob content-type");
        org.testng.Assert.assertEquals((String)CryptoStreams.hex((byte[])metadata.getContentMetadata().getContentMD5()), (String)metadata.getETag(), (String)"Wrong blob MD5");
        org.testng.Assert.assertEquals((Object)metadata.getLocation(), null, (String)"Wrong blob location");
        org.testng.Assert.assertEquals((String)metadata.getProviderId(), null, (String)"Wrong blob provider id");
        org.testng.Assert.assertEquals((Object)metadata.getUri(), null, (String)"Wrong blob URI");
        org.testng.Assert.assertNotNull((Object)metadata.getUserMetadata(), (String)"No blob UserMetadata");
        org.testng.Assert.assertEquals((int)metadata.getUserMetadata().size(), (int)0, (String)"Wrong blob UserMetadata");
        File file = new File(TARGET_CONTAINER_NAME + File.separator + BLOB_KEY);
        org.testng.Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)new Long(file.length()), (String)"Wrong blob size");
    }

    public void testDeleteContainer_NotExistingContainer() {
        try {
            this.blobStore.deleteContainer(CONTAINER_NAME);
            org.testng.Assert.fail((String)"No error when container doesn't exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDeleteContainer_EmptyContanier() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        boolean result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertTrue((boolean)result, (String)"Container doesn't exists");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        this.blobStore.deleteContainer(CONTAINER_NAME);
        result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertFalse((boolean)result, (String)"Container still exists");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
    }

    public void testDeleteContainer() throws IOException {
        String CONTAINER_NAME2 = "container-to-delete";
        String TARGET_CONTAINER_NAME2 = TestUtils.TARGET_BASE_DIR + CONTAINER_NAME2;
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME2);
        boolean result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertTrue((boolean)result, (String)"Container [fun-blobstore-test] doesn't exists");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, true);
        result = this.blobStore.containerExists(CONTAINER_NAME2);
        org.testng.Assert.assertTrue((boolean)result, (String)("Container [" + CONTAINER_NAME2 + "] doesn't exists"));
        TestUtils.directoryExists(TARGET_CONTAINER_NAME2, true);
        TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("testutils-", null), TestUtils.createRandomBlobKey("testutils-", null), TestUtils.createRandomBlobKey("ab123s" + File.separator + "testutils-", null));
        TestUtils.createBlobsInContainer(CONTAINER_NAME, TestUtils.createRandomBlobKey("testutils-", null), TestUtils.createRandomBlobKey("testutils-", null), TestUtils.createRandomBlobKey("asda123s" + File.separator + "testutils-", null), TestUtils.createRandomBlobKey("123-_3s" + File.separator + "testutils-", null));
        this.blobStore.deleteContainer(CONTAINER_NAME);
        result = this.blobStore.containerExists(CONTAINER_NAME);
        org.testng.Assert.assertFalse((boolean)result, (String)"Container [fun-blobstore-test] still exists");
        TestUtils.directoryExists(TARGET_CONTAINER_NAME, false);
        result = this.blobStore.containerExists(CONTAINER_NAME2);
        org.testng.Assert.assertTrue((boolean)result, (String)("Container [" + CONTAINER_NAME2 + "] still exists"));
        TestUtils.directoryExists(TARGET_CONTAINER_NAME2, true);
        this.blobStore.deleteContainer(CONTAINER_NAME2);
        result = this.blobStore.containerExists(CONTAINER_NAME2);
        org.testng.Assert.assertFalse((boolean)result, (String)("Container [" + CONTAINER_NAME2 + "] still exists"));
        TestUtils.directoryExists(TARGET_CONTAINER_NAME2, false);
    }

    @Test(dataProvider="ignoreOnWindows", description="see http://code.google.com/p/jclouds/issues/detail?id=737")
    public void testInvalidContainerName() {
        try {
            this.blobStore.createContainerInLocation(null, "file/system");
            org.testng.Assert.fail((String)"Wrong container name not recognized");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.blobStore.containerExists("file/system");
            org.testng.Assert.fail((String)"Wrong container name not recognized");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRanges() throws IOException {
        String containerName = "containerWithRanges";
        String payload = "abcdefgh";
        Blob blob = this.blobStore.blobBuilder("test").payload((Payload)new StringPayload(payload)).build();
        this.blobStore.putBlob("containerWithRanges", blob);
        GetOptions getOptionsRangeStartAt = new GetOptions();
        getOptionsRangeStartAt.startAt(1L);
        Blob blobRangeStartAt = this.blobStore.getBlob("containerWithRanges", blob.getMetadata().getName(), getOptionsRangeStartAt);
        InputStream is = blobRangeStartAt.getPayload().getInput();
        try {
            Assert.assertEquals((String)"bcdefgh", (String)IOUtils.toString((InputStream)is));
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
        GetOptions getOptionsRangeTail = new GetOptions();
        getOptionsRangeTail.tail(3L);
        Blob blobRangeTail = this.blobStore.getBlob("containerWithRanges", blob.getMetadata().getName(), getOptionsRangeTail);
        is = blobRangeTail.getPayload().getInput();
        try {
            Assert.assertEquals((String)"fgh", (String)IOUtils.toString((InputStream)is));
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
        GetOptions getOptionsFragment = new GetOptions();
        getOptionsFragment.range(4L, 6L);
        Blob blobFragment = this.blobStore.getBlob("containerWithRanges", blob.getMetadata().getName(), getOptionsFragment);
        is = blobFragment.getPayload().getInput();
        try {
            Assert.assertEquals((String)"efg", (String)IOUtils.toString((InputStream)is));
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
    }

    public void testBlobRequestSigner() throws Exception {
        String containerName = "container";
        String blobName = "blob";
        URI endPoint = new URI("http", "localhost", String.format("/transient/%s/%s", containerName, blobName), null);
        BlobRequestSigner signer = this.context.getSigner();
        HttpRequest request = signer.signGetBlob(containerName, blobName);
        HttpRequest expected = HttpRequest.builder().method("GET").endpoint(endPoint).headers(request.getHeaders()).build();
        org.testng.Assert.assertEquals((Object)expected, (Object)request);
        request = signer.signRemoveBlob(containerName, blobName);
        expected = HttpRequest.builder().method("DELETE").endpoint(endPoint).headers(request.getHeaders()).build();
        org.testng.Assert.assertEquals((Object)expected, (Object)request);
        Blob blob = this.blobStore.blobBuilder(blobName).forSigning().build();
        request = signer.signPutBlob(containerName, blob);
        expected = HttpRequest.builder().method("PUT").endpoint(endPoint).headers(request.getHeaders()).payload((Payload)new PhantomPayload()).build();
        org.testng.Assert.assertEquals((Object)expected, (Object)request);
    }

    private Blob createBlob(String keyName, File filePayload) {
        return this.blobStore.blobBuilder(keyName).payload(filePayload).build();
    }

    private void checkForContainerContent(String containerName, Set<String> expectedBlobKeys) {
        this.checkForContainerContent(containerName, null, expectedBlobKeys);
    }

    private void checkForContainerContent(String containerName, String inDirectory, Set<String> expectedBlobKeys) {
        ListContainerOptions options = ListContainerOptions.Builder.recursive();
        if (null != inDirectory && !"".equals(inDirectory)) {
            options.inDirectory(inDirectory);
        }
        PageSet blobsRetrieved = this.blobStore.list(containerName, options);
        if (null == expectedBlobKeys || 0 == expectedBlobKeys.size()) {
            org.testng.Assert.assertTrue((boolean)blobsRetrieved.isEmpty(), (String)("Wrong blob number retrieved in the containter [" + containerName + "]"));
            return;
        }
        HashSet<String> expectedBlobKeysCopy = new HashSet<String>();
        for (String value : expectedBlobKeys) {
            expectedBlobKeysCopy.add(value);
        }
        org.testng.Assert.assertEquals((int)blobsRetrieved.size(), (int)expectedBlobKeysCopy.size(), (String)("Wrong blob number retrieved in the containter [" + containerName + "]"));
        for (StorageMetadata data : blobsRetrieved) {
            String blobName = data.getName();
            if (expectedBlobKeysCopy.remove(blobName)) continue;
            org.testng.Assert.fail((String)("List for container [" + containerName + "] contains unexpected value [" + blobName + "]"));
        }
        org.testng.Assert.assertTrue((boolean)expectedBlobKeysCopy.isEmpty(), (String)("List operation for container [" + containerName + "] doesn't return all values."));
    }

    private void putBlobAndCheckIt(String blobKey) {
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + blobKey, false);
        Blob blob = this.createBlob(blobKey, TestUtils.getImageForBlobPayload());
        String eTag = this.blobStore.putBlob(CONTAINER_NAME, blob);
        org.testng.Assert.assertNotNull((Object)eTag, (String)"putBlob result null");
        org.testng.Assert.assertNotSame((Object)eTag, (Object)"", (String)"putBlob result empty");
        TestUtils.fileExists(TARGET_CONTAINER_NAME + File.separator + blobKey, true);
    }

    static {
        System.setProperty(LOGGING_CONFIG_KEY, LOGGING_CONFIG_VALUE);
    }
}

