/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.integration;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Properties;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStoreContextFactory;
import org.jclouds.blobstore.integration.TransientBlobStoreTestInitializer;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.filesystem.utils.TestUtils;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;

public class FilesystemTestInitializer
extends TransientBlobStoreTestInitializer {
    public FilesystemTestInitializer() {
        this.provider = "filesystem";
        BaseBlobStoreIntegrationTest.SANITY_CHECK_RETURNED_BUCKET_NAME = true;
    }

    protected BlobStoreContext createLiveContext(Module configurationModule, String endpoint, String apiVersion, String buildVersion, String app, String identity, String credential) throws IOException {
        return new BlobStoreContextFactory().createContext(this.provider, (Iterable)ImmutableSet.of((Object)configurationModule, (Object)new Log4JLoggingModule()), this.setupProperties(endpoint, apiVersion, buildVersion, identity, credential));
    }

    protected Properties setupProperties(String endpoint, String apiVersion, String buildVersion, String identity, String credential) {
        Properties props = super.setupProperties(endpoint, apiVersion, buildVersion, identity, credential);
        props.setProperty("jclouds.filesystem.basedir", TestUtils.TARGET_BASE_DIR);
        return props;
    }
}

